/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.prism.Image;
import com.sun.prism.ImageFormatTool;
import com.sun.prism.PixelFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

public class PixelUtils {
    private PixelUtils() {
    }

    public static Pixels imageToPixels(Image image) {
        PixelFormat.DataType dataType = image.getDataType();
        Application application = Application.GetApplication();
        int n = Pixels.getNativeFormat();
        Pixels pixels = null;
        if (dataType == PixelFormat.DataType.BYTE) {
            ByteBuffer byteBuffer = (ByteBuffer)image.getPixelBuffer();
            if (image.getBytesPerPixelUnit() == 3) {
                switch (n) {
                    case 2: {
                        byteBuffer = ImageFormatTool.RGBtoARGB(byteBuffer);
                        break;
                    }
                    case 1: {
                        ByteBuffer byteBuffer2 = ImageFormatTool.RGBtoBGRA(byteBuffer);
                        byteBuffer = ImageFormatTool.BGRAtoBGRA_PRE(byteBuffer2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unhandled native format: " + n);
                    }
                }
            } else if (image.getPixelFormat() != PixelFormat.BYTE_BGRA_PRE) {
                throw new IllegalArgumentException("non-RGB image format");
            }
            pixels = application.createPixels(image.getWidth(), image.getHeight(), byteBuffer);
            return pixels;
        }
        if (dataType == PixelFormat.DataType.INT) {
            if (ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                throw new UnsupportedOperationException("INT_ARGB_PRE only supported for LITTLE_ENDIAN machines");
            }
            IntBuffer intBuffer = (IntBuffer)image.getPixelBuffer();
            pixels = application.createPixels(image.getWidth(), image.getHeight(), intBuffer);
            return pixels;
        }
        throw new IllegalArgumentException("unhandled image type: " + (Object)((Object)dataType));
    }

    public static Image pixelsToImage(Pixels pixels) {
        Buffer buffer = pixels.getPixels();
        if (pixels.getBytesPerComponent() == 1) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(buffer.capacity());
            byteBuffer.put((ByteBuffer)buffer);
            byteBuffer.rewind();
            return Image.fromByteBgraPreData(byteBuffer, pixels.getWidth(), pixels.getHeight());
        }
        if (pixels.getBytesPerComponent() == 4) {
            IntBuffer intBuffer = IntBuffer.allocate(buffer.capacity());
            intBuffer.put((IntBuffer)buffer);
            intBuffer.rewind();
            return Image.fromIntArgbPreData((IntBuffer)buffer, pixels.getWidth(), pixels.getHeight());
        }
        throw new IllegalArgumentException("unhandled pixel buffer: " + buffer.getClass().getName());
    }
}

