/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.jmx.HighlightRegion;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.sg.DirtyRegionContainer;
import com.sun.javafx.sg.DirtyRegionPool;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.Toolkit;
import com.sun.javafx.tk.quantum.PrismPen;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.GraphicsResource;
import com.sun.prism.Presentable;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderingContext;
import com.sun.prism.ResourceFactory;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.camera.PrismPerspectiveCameraImpl;
import com.sun.prism.impl.BufferUtil;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public class PaintRunnable
implements Runnable {
    static ReentrantLock renderLock = new ReentrantLock();
    private int width;
    private int height;
    IntBuffer textureBits;
    RTTexture rttexture;
    Presentable presentable;
    RenderingContext context = null;
    Rectangle dirtyRect;
    RectBounds clip;
    RectBounds dirtyRegionTemp;
    DirtyRegionPool dirtyRegionPool;
    DirtyRegionContainer dirtyRegionContainer;
    Affine3D tx;
    Affine3D scaleTx;
    GeneralTransform3D viewProjTx;
    GeneralTransform3D projTx;
    NGNode root;
    ViewScene scene;
    PrismPen pen;
    private int penWidth = -1;
    private int penHeight = -1;

    protected PaintRunnable(ViewScene viewScene, PrismPen prismPen) {
        if (PrismSettings.dirtyOptsEnabled) {
            this.tx = new Affine3D();
            this.viewProjTx = new GeneralTransform3D();
            this.projTx = new GeneralTransform3D();
            this.scaleTx = new Affine3D();
            this.clip = new RectBounds();
            this.dirtyRect = new Rectangle();
            this.dirtyRegionTemp = new RectBounds();
            this.dirtyRegionPool = new DirtyRegionPool(PrismSettings.dirtyRegionCount);
            this.dirtyRegionContainer = this.dirtyRegionPool.checkOut();
        }
        this.scene = viewScene;
        this.pen = prismPen;
    }

    protected void setRoot(NGNode nGNode) {
        this.root = nGNode;
    }

    protected NGNode getRoot() {
        return this.root;
    }

    private int setDirtyRect(Graphics graphics) {
        this.clip.setBounds(0.0f, 0.0f, this.width, this.height);
        this.dirtyRegionTemp.makeEmpty();
        this.dirtyRegionContainer.reset();
        this.tx.setToIdentity();
        this.projTx.setIdentity();
        PrismCameraImpl prismCameraImpl = (PrismCameraImpl)this.pen.getCamera();
        if (prismCameraImpl instanceof PrismPerspectiveCameraImpl) {
            this.scaleTx.setToScale((double)this.width / 2.0, (double)(-this.height) / 2.0, 1.0);
            this.scaleTx.translate(1.0, -1.0);
            this.projTx.mul(this.scaleTx);
            this.viewProjTx = prismCameraImpl.getProjViewTx(this.viewProjTx, this.width, this.height, false);
            this.projTx.mul(this.viewProjTx);
        }
        int n = this.root.accumulateDirtyRegions(this.clip, this.dirtyRegionTemp, this.dirtyRegionPool, this.dirtyRegionContainer, this.tx, this.projTx);
        return n;
    }

    protected void paintImpl(Graphics graphics) {
        if (graphics != null) {
            Set<HighlightRegion> set;
            Object object;
            int n;
            int n2 = 0;
            if (PrismSettings.dirtyOptsEnabled && !this.scene.isEntireSceneDirty() && (n2 = this.setDirtyRect(graphics)) == 1) {
                this.root.doPreCulling(this.dirtyRegionContainer, this.tx, this.projTx);
            }
            if (!PrismSettings.showDirtyRegions && n2 == 1) {
                graphics.setHasPreCullingBits(true);
                for (n = 0; n < this.dirtyRegionContainer.size(); ++n) {
                    object = this.dirtyRegionContainer.getDirtyRegion(n);
                    if (!(((RectBounds)object).getWidth() > 0.0f) || !(((RectBounds)object).getHeight() > 0.0f)) continue;
                    this.dirtyRect.setBounds((BaseBounds)object);
                    graphics.setClipRect(this.dirtyRect);
                    graphics.setClipRectIndex(n);
                    this.doPaint(graphics);
                }
            } else {
                graphics.setHasPreCullingBits(false);
                graphics.setClipRect(null);
                this.doPaint(graphics);
            }
            if (PrismSettings.showDirtyRegions) {
                if (PrismSettings.showCull) {
                    this.root.drawCullBits(graphics);
                }
                graphics.setDepthTest(false);
                if (n2 == 1) {
                    graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                    for (n = 0; n < this.dirtyRegionContainer.size(); ++n) {
                        object = this.dirtyRegionContainer.getDirtyRegion(n);
                        graphics.fillRect(((RectBounds)object).getMinX(), ((RectBounds)object).getMinY(), ((RectBounds)object).getWidth(), ((RectBounds)object).getHeight());
                    }
                } else {
                    graphics.setPaint(new Color(1.0f, 0.0f, 0.0f, 0.3f));
                    graphics.fillRect(0.0f, 0.0f, this.width, this.height);
                }
            }
            if (SystemProperties.isDebug() && (set = Toolkit.getToolkit().getHighlightedRegions()) != null) {
                graphics.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f));
                for (HighlightRegion highlightRegion : set) {
                    if (!this.scene.equals(highlightRegion.getTKScene())) continue;
                    graphics.setPaint(new Color(1.0f, 1.0f, 1.0f, 1.0f));
                    graphics.drawRect((float)highlightRegion.getMinX(), (float)highlightRegion.getMinY(), (float)highlightRegion.getWidth(), (float)highlightRegion.getHeight());
                    graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, 1.0f));
                    graphics.drawRect((float)highlightRegion.getMinX() - 1.0f, (float)highlightRegion.getMinY() - 1.0f, (float)highlightRegion.getWidth() + 2.0f, (float)highlightRegion.getHeight() + 2.0f);
                }
            }
        }
    }

    private void doPaint(Graphics graphics) {
        Paint paint;
        if (PrismSettings.showDirtyRegions) {
            graphics.setClipRect(null);
        }
        this.scene.clearEntireSceneDirty();
        graphics.setDepthBuffer(this.pen.getDepthBuffer());
        Color color = this.pen.getClearColor();
        if (color != null) {
            graphics.clear(color);
        }
        if ((paint = this.pen.getCurrentPaint()) != null) {
            graphics.setPaint(paint);
            graphics.fillQuad(0.0f, 0.0f, this.width, this.height);
        }
        graphics.setCamera((PrismCameraImpl)this.pen.getCamera());
        this.root.render(graphics, null, null);
    }

    void disposePresentable() {
        if (this.presentable instanceof GraphicsResource) {
            ((GraphicsResource)((Object)this.presentable)).dispose();
        }
        this.presentable = null;
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        View view = null;
        try {
            Window window;
            if (PrismSettings.threadCheck) {
                assert (!renderLock.isHeldByCurrentThread());
                renderLock.lock();
            }
            Object object = this;
            synchronized (object) {
                block39: {
                    this.pen.getPainting().set(false);
                    view = this.scene.getPlatformView();
                    if (view != null) break block39;
                    return;
                }
                this.width = view.getWidth();
                this.height = view.getHeight();
                this.pen.begin();
            }
            if (this.width <= 0 || this.height <= 0) {
                return;
            }
            object = this.scene.getWindowStage();
            Window window2 = window = object == null ? null : ((WindowStage)object).platformWindow;
            if (window == null || !window.isVisible() || window.isMinimized()) {
                return;
            }
            ResourceFactory resourceFactory = GraphicsPipeline.getDefaultResourceFactory();
            if (!resourceFactory.isDeviceReady()) {
                return;
            }
            if (((WindowStage)object).needsUpdateWindow() && resourceFactory.isOffscreenRenderingSupported()) {
                boolean bl;
                if (Pixels.getNativeFormat() != 1 || ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN) {
                    throw new UnsupportedOperationException("transparent windows only supported for BYTE_BGRA_PRE format on LITTLE_ENDIAN machines");
                }
                boolean bl2 = bl = this.rttexture == null || this.width != this.penWidth || this.height != this.penHeight;
                if (bl) {
                    this.context = resourceFactory.createRenderingContext(null);
                }
                this.context.begin();
                if (bl) {
                    this.disposeRTTexture();
                    this.rttexture = resourceFactory.createRTTexture(this.width, this.height);
                    if (this.rttexture == null) {
                        this.context.end();
                        return;
                    }
                    this.penWidth = this.width;
                    this.penHeight = this.height;
                    this.textureBits = null;
                }
                Graphics graphics = this.rttexture.createGraphics();
                this.paintImpl(graphics);
                int[] nArray = this.rttexture.getPixels();
                Pixels pixels = null;
                Application application = Application.GetApplication();
                if (nArray != null) {
                    pixels = application.createPixels(this.width, this.height, IntBuffer.wrap(nArray));
                } else {
                    if (this.textureBits == null) {
                        this.textureBits = BufferUtil.newIntBuffer(this.width * this.height);
                    }
                    if (this.textureBits != null) {
                        if (this.rttexture.readPixels(this.textureBits)) {
                            pixels = application.createPixels(this.width, this.height, this.textureBits);
                        } else {
                            this.scene.entireSceneNeedsRepaint();
                            this.disposeRTTexture();
                        }
                    }
                }
                this.pen.paintRenderJob.setFutureReturn(pixels);
                this.context.end();
            } else {
                boolean bl;
                boolean bl3 = bl = this.presentable == null || this.penWidth != this.width || this.penHeight != this.height;
                if (bl && (this.presentable == null || this.presentable.recreateOnResize())) {
                    this.context = resourceFactory.createRenderingContext(this.scene.getPlatformView());
                }
                this.context.begin();
                if (bl) {
                    if (this.presentable == null || this.presentable.recreateOnResize()) {
                        this.disposePresentable();
                        this.presentable = resourceFactory.createPresentable(this.scene.getPlatformView());
                        bl = false;
                    }
                    this.penWidth = this.width;
                    this.penHeight = this.height;
                }
                if (this.presentable != null) {
                    Graphics graphics = this.presentable.createGraphics();
                    if (bl) {
                        graphics.reset();
                    }
                    this.paintImpl(graphics);
                    if (!this.presentable.present(null)) {
                        this.disposePresentable();
                        this.scene.entireSceneNeedsRepaint();
                    }
                }
                this.context.end();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            if (PrismSettings.threadCheck) {
                renderLock.unlock();
            }
            if (view != null) {
                this.pen.end();
            }
        }
    }
}

