/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.BaseNodeEffectInput;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrRenderInfo;

public class NodeEffectInput
extends BaseNodeEffectInput {
    private NGNode node;
    private ImageData cachedIdentityImageData;
    private ImageData cachedTransformedImageData;
    private BaseTransform cachedTransform;

    public NodeEffectInput() {
    }

    public NodeEffectInput(NGNode nGNode) {
        super(nGNode);
        this.node = nGNode;
    }

    static boolean contains(ImageData imageData, Rectangle rectangle) {
        Rectangle rectangle2 = imageData.getUntransformedBounds();
        return rectangle2.contains(rectangle);
    }

    @Override
    public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
        Object object2;
        if (object instanceof PrRenderInfo && (object2 = ((PrRenderInfo)object).getGraphics()) != null) {
            this.render((Graphics)object2, baseTransform);
            return null;
        }
        object2 = NodeEffectInput.getImageBoundsForNode(this.node, true, baseTransform, rectangle);
        if (baseTransform.isIdentity()) {
            if (this.cachedIdentityImageData != null && NodeEffectInput.contains(this.cachedIdentityImageData, (Rectangle)object2) && this.cachedIdentityImageData.validate(filterContext)) {
                this.cachedIdentityImageData.addref();
                return this.cachedIdentityImageData;
            }
        } else if (this.cachedTransformedImageData != null && NodeEffectInput.contains(this.cachedTransformedImageData, (Rectangle)object2) && this.cachedTransformedImageData.validate(filterContext) && this.cachedTransform.equals(baseTransform)) {
            this.cachedTransformedImageData.addref();
            return this.cachedTransformedImageData;
        }
        ImageData imageData = NodeEffectInput.getImageDataForBoundedNode(filterContext, this.node, true, baseTransform, (Rectangle)object2);
        if (baseTransform.isIdentity()) {
            this.flushIdentityImage();
            this.cachedIdentityImageData = imageData;
            this.cachedIdentityImageData.addref();
        } else {
            this.flushTransformedImage();
            this.cachedTransform = baseTransform.copy();
            this.cachedTransformedImageData = imageData;
            this.cachedTransformedImageData.addref();
        }
        return imageData;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext filterContext) {
        return Effect.AccelType.INTRINSIC;
    }

    public void flushIdentityImage() {
        if (this.cachedIdentityImageData != null) {
            this.cachedIdentityImageData.unref();
            this.cachedIdentityImageData = null;
        }
    }

    public void flushTransformedImage() {
        if (this.cachedTransformedImageData != null) {
            this.cachedTransformedImageData.unref();
            this.cachedTransformedImageData = null;
        }
        this.cachedTransform = null;
    }

    @Override
    public void flush() {
        this.flushIdentityImage();
        this.flushTransformedImage();
    }

    public void render(Graphics graphics, BaseTransform baseTransform) {
        BaseTransform baseTransform2 = null;
        if (!baseTransform.isIdentity()) {
            baseTransform2 = graphics.getTransformNoClone().copy();
            graphics.transform(baseTransform);
        }
        this.node.renderContent(graphics);
        if (baseTransform2 != null) {
            graphics.setTransform(baseTransform2);
        }
    }

    static ImageData getImageDataForNode(FilterContext filterContext, NGNode nGNode, boolean bl, BaseTransform baseTransform, Rectangle rectangle) {
        Rectangle rectangle2 = NodeEffectInput.getImageBoundsForNode(nGNode, bl, baseTransform, rectangle);
        return NodeEffectInput.getImageDataForBoundedNode(filterContext, nGNode, bl, baseTransform, rectangle2);
    }

    static Rectangle getImageBoundsForNode(NGNode nGNode, boolean bl, BaseTransform baseTransform, Rectangle rectangle) {
        BaseBounds baseBounds = new RectBounds();
        baseBounds = bl ? nGNode.getContentBounds(baseBounds, baseTransform) : nGNode.getCompleteBounds(baseBounds, baseTransform);
        Rectangle rectangle2 = new Rectangle(baseBounds);
        if (rectangle != null) {
            rectangle2.intersectWith(rectangle);
        }
        return rectangle2;
    }

    private static ImageData getImageDataForBoundedNode(FilterContext filterContext, NGNode nGNode, boolean bl, BaseTransform baseTransform, Rectangle rectangle) {
        PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(filterContext, rectangle.width, rectangle.height);
        if (prDrawable != null) {
            Graphics graphics = prDrawable.createGraphics();
            graphics.translate(-rectangle.x, -rectangle.y);
            if (baseTransform != null) {
                graphics.transform(baseTransform);
            }
            if (bl) {
                nGNode.renderContent(graphics);
            } else {
                nGNode.render(graphics, null, null);
            }
        }
        return new ImageData(filterContext, prDrawable, rectangle);
    }
}

