/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.text.Font;

public class Margins {
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private final boolean proportional;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public Margins(double d, double d2, double d3, double d4, boolean bl) {
        this.top = d;
        this.right = d2;
        this.bottom = d3;
        this.left = d4;
        this.proportional = bl;
    }

    public String toString() {
        return "top: " + this.top + "\nright: " + this.right + "\nbottom: " + this.bottom + "\nleft: " + this.left;
    }

    public static final class SequenceConverter
    extends StyleConverter<Value<Value<?, Size>[], Margins>[], Margins[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_CONVERTER_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Margins[] convert(Value<Value<Value<?, Size>[], Margins>[], Margins[]> value, Font font) {
            Value<Value<?, Size>[], Margins>[] valueArray = value.getValue();
            Margins[] marginsArray = new Margins[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                marginsArray[i] = Converter.getInstance().convert((Value)valueArray[i], font);
            }
            return marginsArray;
        }

        public String toString() {
            return "MarginsSequenceConverter";
        }
    }

    public static final class Converter
    extends StyleConverter<Value<?, Size>[], Margins> {
        public static Converter getInstance() {
            return Holder.CONVERTER_INSTANCE;
        }

        private Converter() {
        }

        @Override
        public Margins convert(Value<Value<?, Size>[], Margins> value, Font font) {
            Value<?, Size>[] valueArray = value.getValue();
            Size size = valueArray.length > 0 ? valueArray[0].convert(font) : new Size(0.0, SizeUnits.PX);
            Size size2 = valueArray.length > 1 ? valueArray[1].convert(font) : size;
            Size size3 = valueArray.length > 2 ? valueArray[2].convert(font) : size;
            Size size4 = valueArray.length > 3 ? valueArray[3].convert(font) : size2;
            boolean bl = false;
            if (size.getUnits() == size2.getUnits() && size.getUnits() == size3.getUnits() && size.getUnits() == size4.getUnits()) {
                bl = size.getUnits() == SizeUnits.PERCENT;
            } else {
                System.err.println("units do not match");
            }
            double d = size.pixels(font);
            double d2 = size2.pixels(font);
            double d3 = size3.pixels(font);
            double d4 = size4.pixels(font);
            return new Margins(d, d2, d3, d4, bl);
        }

        public String toString() {
            return "MarginsConverter";
        }
    }

    private static class Holder {
        static Converter CONVERTER_INSTANCE = new Converter();
        static SequenceConverter SEQUENCE_CONVERTER_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

