/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.runnable.Runnable0;
import com.sun.javafx.runnable.Runnable1;
import com.sun.javafx.scene.control.skin.PositionMapper;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Cell;
import javafx.scene.control.IndexedCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

public class VirtualFlow
extends Region {
    private BooleanProperty vertical;
    private boolean pannable = true;
    private int cellCount;
    private DoubleProperty position;
    private Runnable0<? extends IndexedCell> createCell;
    private final PositionMapper mapper;
    private int numCellsVisibleOnScreen = -1;
    double maxPrefBreadth;
    double viewportBreadth;
    double viewportLength;
    double lastWidth = -1.0;
    double lastHeight = -1.0;
    int lastCellCount = 0;
    boolean lastVertical;
    double lastPosition;
    double lastCellBreadth = -1.0;
    double lastCellLength = -1.0;
    final ArrayLinkedList<IndexedCell> cells = new ArrayLinkedList();
    final ArrayLinkedList<IndexedCell> pile = new ArrayLinkedList();
    IndexedCell accumCell;
    Group accumCellParent;
    Group sheet;
    private VirtualScrollBar hbar = new VirtualScrollBar(this);
    private VirtualScrollBar vbar = new VirtualScrollBar(this);
    ClippedContainer clipView;
    StackPane corner;
    private double lastX;
    private double lastY;
    private boolean isPanning = false;
    private static final double GOLDEN_RATIO_MULTIPLIER = 0.618033987;

    public final void setVertical(boolean bl) {
        this.verticalProperty().set(bl);
    }

    public final boolean isVertical() {
        return this.vertical == null ? true : this.vertical.get();
    }

    public final BooleanProperty verticalProperty() {
        if (this.vertical == null) {
            this.vertical = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    VirtualFlow.this.addAllToPile();
                    VirtualFlow.this.maxPrefBreadth = -1.0;
                    VirtualFlow.this.lastHeight = -1.0;
                    VirtualFlow.this.lastWidth = -1.0;
                    VirtualFlow.this.lastPosition = 0.0;
                    VirtualFlow.this.viewportLength = 0.0;
                    VirtualFlow.this.viewportBreadth = 0.0;
                    VirtualFlow.this.hbar.setValue(0.0);
                    VirtualFlow.this.vbar.setValue(0.0);
                    VirtualFlow.this.mapper.adjustPosition(0.0);
                    VirtualFlow.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return VirtualFlow.this;
                }

                @Override
                public String getName() {
                    return "vertical";
                }
            };
        }
        return this.vertical;
    }

    public boolean isPannable() {
        return this.pannable;
    }

    public void setPannable(boolean bl) {
        this.pannable = bl;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public void setCellCount(int n) {
        this.cellCount = n;
        VirtualScrollBar virtualScrollBar = this.isVertical() ? this.vbar : this.hbar;
        virtualScrollBar.setMax(n);
        this.layoutChildren();
        this.sheet.getChildren().clear();
        Parent parent = this.getParent();
        if (parent != null) {
            parent.requestLayout();
        }
    }

    public final void setPosition(double d) {
        this.positionProperty().set(d);
    }

    public final double getPosition() {
        return this.position == null ? 0.0 : this.position.get();
    }

    public final DoubleProperty positionProperty() {
        if (this.position == null) {
            this.position = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    if (this.get() != VirtualFlow.this.mapper.getPosition()) {
                        VirtualFlow.this.mapper.adjustPosition(this.get());
                        VirtualFlow.this.requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return VirtualFlow.this;
                }

                @Override
                public String getName() {
                    return "position";
                }
            };
        }
        return this.position;
    }

    public Runnable0<? extends IndexedCell> getCreateCell() {
        return this.createCell;
    }

    protected void setCreateCell(Runnable0<? extends IndexedCell> runnable0) {
        this.createCell = runnable0;
        if (this.createCell != null) {
            this.recreateCells();
            if (this.getParent() != null) {
                this.getParent().requestLayout();
            }
        }
    }

    final VirtualScrollBar getHbar() {
        return this.hbar;
    }

    final VirtualScrollBar getVbar() {
        return this.vbar;
    }

    public VirtualFlow() {
        this.mapper = new PositionMapper();
        this.mapper.setGetItemSize(new Runnable1<Double, Integer>(){

            @Override
            public Double run(Integer n) {
                return VirtualFlow.this.getCellLength(n);
            }
        });
        this.initContent();
        this.initBinds();
    }

    private void initContent() {
        this.sheet = new Group();
        this.sheet.setAutoSizeChildren(false);
        this.clipView = new ClippedContainer(this);
        this.clipView.setNode(this.sheet);
        this.getChildren().add(this.clipView);
        this.accumCellParent = new Group();
        this.accumCellParent.setManaged(false);
        this.accumCellParent.setVisible(false);
        this.getChildren().add(this.accumCellParent);
        this.addEventFilter(ScrollEvent.SCROLL, new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                double d = 0.0;
                if (VirtualFlow.this.isVertical()) {
                    switch (scrollEvent.getTextDeltaYUnits()) {
                        case PAGES: {
                            d = scrollEvent.getTextDeltaY() * VirtualFlow.this.lastHeight;
                            break;
                        }
                        case LINES: {
                            d = scrollEvent.getTextDeltaY() * VirtualFlow.this.lastCellLength;
                            break;
                        }
                        case NONE: {
                            d = scrollEvent.getDeltaY();
                        }
                    }
                } else {
                    switch (scrollEvent.getTextDeltaXUnits()) {
                        case CHARACTERS: 
                        case NONE: {
                            double d2 = scrollEvent.getDeltaX();
                            double d3 = scrollEvent.getDeltaY();
                            d = Math.abs(d2) > Math.abs(d3) ? d2 : d3;
                        }
                    }
                }
                VirtualFlow.this.adjustPixels(-d);
                scrollEvent.consume();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (VirtualFlow.this.isFocusTraversable()) {
                    VirtualFlow.this.requestFocus();
                }
                VirtualFlow.this.lastX = mouseEvent.getX();
                VirtualFlow.this.lastY = mouseEvent.getY();
                VirtualFlow.this.isPanning = !VirtualFlow.this.vbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY()) && !VirtualFlow.this.hbar.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY());
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                VirtualScrollBar virtualScrollBar;
                if (!VirtualFlow.this.isPanning || !VirtualFlow.this.isPannable()) {
                    return;
                }
                double d = VirtualFlow.this.lastX - mouseEvent.getX();
                double d2 = VirtualFlow.this.lastY - mouseEvent.getY();
                double d3 = VirtualFlow.this.isVertical() ? d2 : d;
                double d4 = VirtualFlow.this.adjustPixels(d3);
                if (d4 != 0.0) {
                    if (VirtualFlow.this.isVertical()) {
                        VirtualFlow.this.lastY = mouseEvent.getY();
                    } else {
                        VirtualFlow.this.lastX = mouseEvent.getX();
                    }
                }
                double d5 = VirtualFlow.this.isVertical() ? d : d2;
                VirtualScrollBar virtualScrollBar2 = virtualScrollBar = VirtualFlow.this.isVertical() ? VirtualFlow.this.hbar : VirtualFlow.this.vbar;
                if (virtualScrollBar.isVisible()) {
                    double d6 = virtualScrollBar.getValue() + d5;
                    if (d6 < virtualScrollBar.getMin()) {
                        virtualScrollBar.setValue(virtualScrollBar.getMin());
                    } else if (d6 > virtualScrollBar.getMax()) {
                        virtualScrollBar.setValue(virtualScrollBar.getMax());
                    } else {
                        virtualScrollBar.setValue(d6);
                        if (VirtualFlow.this.isVertical()) {
                            VirtualFlow.this.lastX = mouseEvent.getX();
                        } else {
                            VirtualFlow.this.lastY = mouseEvent.getY();
                        }
                    }
                }
            }
        });
        this.vbar.setOrientation(Orientation.VERTICAL);
        this.vbar.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.getChildren().add(this.vbar);
        this.hbar.setOrientation(Orientation.HORIZONTAL);
        this.hbar.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
            }
        });
        this.getChildren().add(this.hbar);
        this.corner = new StackPane();
        this.corner.getStyleClass().setAll((String[])new String[]{"corner"});
        this.getChildren().add(this.corner);
    }

    private void initBinds() {
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                VirtualFlow.this.updateHbar();
            }
        };
        this.verticalProperty().addListener(invalidationListener);
        this.hbar.valueProperty().addListener(invalidationListener);
        this.hbar.visibleProperty().addListener(invalidationListener);
        this.mapper.positionProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                VirtualFlow.this.setPosition(VirtualFlow.this.mapper.getPosition());
            }
        });
        super.heightProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                if (number.doubleValue() == 0.0 && number2.doubleValue() > 0.0) {
                    VirtualFlow.this.recreateCells();
                }
            }
        });
    }

    void updateHbar() {
        if (!this.isVisible() || this.getScene() == null) {
            return;
        }
        if (this.isVertical()) {
            if (this.hbar.isVisible()) {
                this.clipView.setClipX(this.hbar.getValue());
            } else {
                this.clipView.setClipX(0.0);
                this.hbar.setValue(0.0);
            }
        }
    }

    @Override
    public void requestLayout() {
        if (this.getScene() != null && !this.isNeedsLayout()) {
            this.getScene().addToDirtyLayoutList(this);
            this.setNeedsLayout(true);
        }
    }

    @Override
    protected void layoutChildren() {
        boolean bl;
        double d;
        boolean bl2;
        Cell cell;
        if (this.getWidth() <= 0.0 || this.getHeight() <= 0.0) {
            this.addAllToPile();
            this.hbar.setVisible(false);
            this.vbar.setVisible(false);
            this.corner.setVisible(false);
            return;
        }
        boolean bl3 = false;
        for (int i = 0; i < this.cells.size() && !(bl3 = (cell = (Cell)this.cells.get(i)).isNeedsLayout()); ++i) {
        }
        cell = null;
        IndexedCell indexedCell = this.getFirstVisibleCell();
        if (!bl3) {
            bl2 = false;
            if (indexedCell != null) {
                double d2 = this.getCellBreadth(indexedCell);
                d = this.getCellLength(indexedCell);
                bl2 = d2 != this.lastCellBreadth || d != this.lastCellLength;
                this.lastCellBreadth = d2;
                this.lastCellLength = d;
            }
            if (this.getWidth() == this.lastWidth && this.getHeight() == this.lastHeight && this.getCellCount() == this.lastCellCount && this.isVertical() == this.lastVertical && this.getPosition() == this.lastPosition && !bl2) {
                return;
            }
        }
        bl2 = false;
        boolean bl4 = bl = bl3 || this.isVertical() != this.lastVertical || this.cells.isEmpty() || this.maxPrefBreadth == -1.0 || this.getPosition() != this.lastPosition || this.getCellCount() != this.lastCellCount;
        if (!bl) {
            if (this.isVertical() && this.getHeight() < this.lastHeight || !this.isVertical() && this.getWidth() < this.lastWidth) {
                bl = true;
            } else if (this.isVertical() && this.getHeight() > this.lastHeight || !this.isVertical() && this.getWidth() > this.lastWidth) {
                bl2 = true;
            }
        }
        this.updateViewport();
        int n = this.mapper.computeCurrentIndex();
        if (this.lastCellCount != this.getCellCount()) {
            if (this.getPosition() == 0.0 || this.getPosition() == 1.0) {
                this.mapper.setItemCount(this.getCellCount());
            } else if (n >= this.getCellCount()) {
                this.mapper.adjustPosition(1.0);
                this.mapper.setItemCount(this.getCellCount());
            } else if (indexedCell != null) {
                d = this.getCellPosition(indexedCell);
                int n2 = indexedCell.getIndex();
                this.mapper.setItemCount(this.getCellCount());
                if (indexedCell != null) {
                    this.mapper.adjustPositionToIndex(n2);
                    double d3 = -this.mapper.computeOffsetForCell(n2);
                    this.mapper.adjustByPixelAmount(d3 - d);
                }
            }
            n = this.mapper.computeCurrentIndex();
        }
        if (bl) {
            this.addAllToPile();
            d = -this.mapper.computeViewportOffset(this.mapper.getPosition());
            this.addLeadingCells(n, d);
            this.addTrailingCells(true);
        } else if (bl2) {
            this.addTrailingCells(true);
        }
        this.updateViewport();
        this.lastWidth = this.getWidth();
        this.lastHeight = this.getHeight();
        this.lastCellCount = this.getCellCount();
        this.lastVertical = this.isVertical();
        this.lastPosition = this.getPosition();
    }

    private void addLeadingCells(int n, double d) {
        double d2 = d;
        boolean bl = true;
        IndexedCell indexedCell = null;
        for (int i = n; i >= 0 && (d2 > 0.0 || bl); --i) {
            indexedCell = this.getAvailableCell(i);
            this.setCellIndex(indexedCell, i);
            this.resizeCellSize(indexedCell);
            this.cells.addFirst(indexedCell);
            if (bl) {
                bl = false;
            } else {
                d2 -= this.getCellLength(indexedCell);
            }
            this.positionCell(indexedCell, d2);
            this.maxPrefBreadth = Math.max(this.maxPrefBreadth, this.getCellBreadth(indexedCell));
            indexedCell.setVisible(true);
        }
        indexedCell = this.cells.getFirst();
        int n2 = indexedCell.getIndex();
        double d3 = this.getCellPosition(indexedCell);
        if (n2 == 0 && d3 > 0.0) {
            this.mapper.adjustPosition(0.0);
            d2 = 0.0;
            for (int i = 0; i < this.cells.size(); ++i) {
                indexedCell = this.cells.get(i);
                this.positionCell(indexedCell, d2);
                d2 += this.getCellLength(indexedCell);
            }
        }
    }

    private boolean addTrailingCells(boolean bl) {
        IndexedCell indexedCell;
        boolean bl2;
        if (this.cells.isEmpty()) {
            return false;
        }
        IndexedCell indexedCell2 = this.cells.getLast();
        double d = this.getCellPosition(indexedCell2) + this.getCellLength(indexedCell2);
        int n = indexedCell2.getIndex() + 1;
        boolean bl3 = bl2 = n <= this.getCellCount();
        while (d < this.viewportLength) {
            if (n >= this.getCellCount()) {
                if (d < this.viewportLength) {
                    bl2 = false;
                }
                if (!bl) {
                    return bl2;
                }
            }
            indexedCell = this.getAvailableCell(n);
            this.setCellIndex(indexedCell, n);
            this.resizeCellSize(indexedCell);
            this.cells.addLast(indexedCell);
            this.positionCell(indexedCell, d);
            this.maxPrefBreadth = Math.max(this.maxPrefBreadth, this.getCellBreadth(indexedCell));
            d += this.getCellLength(indexedCell);
            indexedCell.setVisible(true);
            ++n;
        }
        indexedCell = this.cells.getFirst();
        n = indexedCell.getIndex();
        IndexedCell indexedCell3 = this.getLastVisibleCell();
        double d2 = this.getCellPosition(indexedCell);
        double d3 = this.getCellPosition(indexedCell3) + this.getCellLength(indexedCell3);
        if ((n != 0 || n == 0 && d2 < 0.0) && bl && indexedCell3 != null && indexedCell3.getIndex() == this.getCellCount() - 1 && d3 < this.viewportLength) {
            double d4;
            double d5 = this.viewportLength - d3;
            for (double d6 = d3; d6 < this.viewportLength && n != 0 && -d2 < d5; d6 += d4) {
                IndexedCell indexedCell4 = this.getAvailableCell(--n);
                this.setCellIndex(indexedCell4, n);
                this.resizeCellSize(indexedCell4);
                this.cells.addFirst(indexedCell4);
                d4 = this.getCellLength(indexedCell4);
                this.positionCell(indexedCell4, d2 -= d4);
                this.maxPrefBreadth = Math.max(this.maxPrefBreadth, this.getCellBreadth(indexedCell4));
                indexedCell4.setVisible(true);
            }
            indexedCell = this.cells.getFirst();
            d2 = this.getCellPosition(indexedCell);
            double d7 = this.viewportLength - d3;
            if (indexedCell.getIndex() == 0 && d7 > -d2) {
                d7 = -d2;
            }
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell indexedCell5 = this.cells.get(i);
                this.positionCell(indexedCell5, this.getCellPosition(indexedCell5) + d7);
            }
            d2 = this.getCellPosition(indexedCell);
            if (indexedCell.getIndex() == 0 && d2 == 0.0) {
                this.mapper.adjustPosition(0.0);
            } else if (this.getPosition() != 1.0) {
                this.mapper.adjustPosition(1.0);
            }
        }
        return bl2;
    }

    private void updateViewport() {
        boolean bl;
        double d = this.viewportLength;
        this.viewportLength = this.isVertical() ? this.getHeight() : this.getWidth();
        this.viewportBreadth = this.isVertical() ? this.getWidth() : this.getHeight();
        VirtualScrollBar virtualScrollBar = this.isVertical() ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = this.isVertical() ? this.vbar : this.hbar;
        double d2 = this.isVertical() ? this.hbar.prefHeight(-1.0) : this.vbar.prefWidth(-1.0);
        double d3 = this.isVertical() ? this.vbar.prefWidth(-1.0) : this.hbar.prefHeight(-1.0);
        virtualScrollBar.setVirtual(false);
        virtualScrollBar2.setVirtual(true);
        if (this.maxPrefBreadth == -1.0) {
            return;
        }
        boolean bl2 = this.getPosition() > 0.0 && (this.getCellCount() >= this.cells.size() || this.viewportLength >= this.getHeight());
        boolean bl3 = bl = this.maxPrefBreadth > this.viewportBreadth || bl2 && this.maxPrefBreadth > this.viewportBreadth - d3;
        if (bl) {
            this.viewportLength -= d2;
        }
        if (bl2) {
            this.viewportBreadth -= d3;
        }
        this.mapper.setViewportSize(this.viewportLength);
        virtualScrollBar.setVisible(bl);
        virtualScrollBar2.setVisible(bl2);
        this.updateScrollBarsAndViewport(d);
    }

    private void updateScrollBarsAndViewport(double d) {
        VirtualScrollBar virtualScrollBar = this.isVertical() ? this.hbar : this.vbar;
        VirtualScrollBar virtualScrollBar2 = this.isVertical() ? this.vbar : this.hbar;
        double d2 = this.isVertical() ? this.hbar.prefHeight(-1.0) : this.vbar.prefWidth(-1.0);
        double d3 = this.isVertical() ? this.vbar.prefWidth(-1.0) : this.hbar.prefHeight(-1.0);
        for (int i = 0; i < 2; ++i) {
            if (!virtualScrollBar2.isVisible()) {
                if (this.getCellCount() > this.cells.size()) {
                    virtualScrollBar2.setVisible(true);
                } else if (this.getCellCount() == this.cells.size()) {
                    IndexedCell indexedCell = this.cells.getLast();
                    virtualScrollBar2.setVisible(this.getCellPosition(indexedCell) + this.getCellLength(indexedCell) > this.viewportLength);
                }
                if (virtualScrollBar2.isVisible()) {
                    this.viewportBreadth -= d3;
                }
            }
            if (virtualScrollBar.isVisible()) continue;
            virtualScrollBar.setVisible(this.maxPrefBreadth > this.viewportBreadth);
            if (!virtualScrollBar.isVisible()) continue;
            this.viewportLength -= d2;
        }
        this.corner.setVisible(virtualScrollBar.isVisible() && virtualScrollBar2.isVisible());
        this.numCellsVisibleOnScreen = 0;
        double d4 = 0.0;
        double d5 = (this.isVertical() ? this.getHeight() : this.getWidth()) - (virtualScrollBar.isVisible() ? virtualScrollBar.prefHeight(-1.0) : 0.0);
        for (int i = 0; i < this.cells.size(); ++i) {
            IndexedCell indexedCell = this.cells.get(i);
            if (indexedCell == null || indexedCell.isEmpty()) continue;
            if ((d4 += this.isVertical() ? indexedCell.getHeight() : indexedCell.getWidth()) > d5) break;
            ++this.numCellsVisibleOnScreen;
        }
        if (virtualScrollBar.isVisible()) {
            if (this.isVertical()) {
                this.hbar.resizeRelocate(0.0, this.viewportLength, this.viewportBreadth, this.hbar.prefHeight(this.viewportBreadth));
            } else {
                this.vbar.resizeRelocate(this.viewportLength, 0.0, this.vbar.prefWidth(this.viewportBreadth), this.viewportBreadth);
            }
            double d6 = Math.max(1.0, this.maxPrefBreadth - this.viewportBreadth);
            if (d6 != virtualScrollBar.getMax()) {
                boolean bl;
                virtualScrollBar.setMax(d6);
                boolean bl2 = bl = virtualScrollBar.getValue() != 0.0 && virtualScrollBar.getMax() == virtualScrollBar.getValue();
                if (bl || virtualScrollBar.getValue() > d6) {
                    virtualScrollBar.setValue(d6);
                }
                virtualScrollBar.setVisibleAmount(this.viewportBreadth / this.maxPrefBreadth * d6);
            }
        }
        if (virtualScrollBar2.isVisible()) {
            virtualScrollBar2.setMax(1.0);
            virtualScrollBar2.setVisibleAmount((float)this.numCellsVisibleOnScreen / (float)this.getCellCount());
            if (this.isVertical()) {
                double d7 = this.viewportLength;
                this.vbar.resizeRelocate(this.viewportBreadth, 0.0, this.vbar.prefWidth(d7), d7);
            } else {
                this.hbar.resizeRelocate(0.0, this.viewportBreadth, this.viewportLength, this.hbar.prefHeight(-1.0));
            }
        }
        if (this.corner.isVisible()) {
            this.corner.resize(this.vbar.getWidth(), this.hbar.getHeight());
            this.corner.relocate(this.hbar.getLayoutX() + this.hbar.getWidth(), this.vbar.getLayoutY() + this.vbar.getHeight());
        }
        this.clipView.resize(this.isVertical() ? this.viewportBreadth : this.viewportLength, this.isVertical() ? this.viewportLength : this.viewportBreadth);
        if (this.mapper.getViewportSize() != this.viewportLength) {
            this.mapper.setViewportSize(this.viewportLength);
        }
        this.fitCells();
        if (this.getPosition() != virtualScrollBar2.getValue()) {
            virtualScrollBar2.setValue(this.getPosition());
        }
    }

    private void fitCells() {
        double d = Math.max(this.maxPrefBreadth, this.viewportBreadth);
        for (int i = 0; i < this.cells.size(); ++i) {
            Cell cell = this.cells.get(i);
            if (this.isVertical()) {
                cell.resize(d, cell.getHeight());
                continue;
            }
            cell.resize(cell.getWidth(), d);
        }
    }

    private void cull() {
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell indexedCell = this.cells.get(i);
            double d = this.getCellLength(indexedCell);
            double d2 = this.getCellPosition(indexedCell);
            double d3 = d2 + d;
            if (!(d2 > this.viewportLength) && !(d3 < 0.0)) continue;
            this.addToPile(this.cells.remove(i));
        }
    }

    IndexedCell getCell(int n) {
        IndexedCell indexedCell;
        if (!this.cells.isEmpty() && (indexedCell = this.getVisibleCell(n)) != null) {
            return indexedCell;
        }
        for (int i = 0; i < this.pile.size(); ++i) {
            IndexedCell indexedCell2 = this.pile.get(i);
            if (indexedCell2 == null || indexedCell2.getIndex() != n) continue;
            return indexedCell2;
        }
        if (this.accumCell == null) {
            this.accumCell = this.getCreateCell().run();
            this.accumCellParent.getChildren().add(this.accumCell);
        }
        this.setCellIndex(this.accumCell, n);
        this.resizeCellSize(this.accumCell);
        return this.accumCell;
    }

    private void releaseCell(IndexedCell indexedCell) {
        if (this.accumCell != null && indexedCell == this.accumCell) {
            this.accumCell.updateIndex(-1);
        }
    }

    double getCellLength(int n) {
        IndexedCell indexedCell = this.getCell(n);
        double d = this.getCellLength(indexedCell);
        this.releaseCell(indexedCell);
        return d;
    }

    double getCellBreadth(int n) {
        IndexedCell indexedCell = this.getCell(n);
        double d = this.getCellBreadth(indexedCell);
        this.releaseCell(indexedCell);
        return d;
    }

    private double getCellLength(IndexedCell indexedCell) {
        if (indexedCell == null) {
            return 0.0;
        }
        return this.isVertical() ? indexedCell.getLayoutBounds().getHeight() : indexedCell.getLayoutBounds().getWidth();
    }

    private double getCellBreadth(Cell cell) {
        return this.isVertical() ? cell.prefWidth(-1.0) : cell.prefHeight(-1.0);
    }

    private double getCellPosition(IndexedCell indexedCell) {
        if (indexedCell == null) {
            return 0.0;
        }
        return this.isVertical() ? indexedCell.getLayoutY() : indexedCell.getLayoutX();
    }

    private void positionCell(IndexedCell indexedCell, double d) {
        if (this.isVertical()) {
            indexedCell.setLayoutX(0.0);
            indexedCell.setLayoutY(this.snapSize(d));
        } else {
            indexedCell.setLayoutX(this.snapSize(d));
            indexedCell.setLayoutY(0.0);
        }
    }

    private void resizeCellSize(IndexedCell indexedCell) {
        if (this.isVertical()) {
            indexedCell.resize(indexedCell.getWidth(), indexedCell.prefHeight(-1.0));
        } else {
            indexedCell.resize(indexedCell.prefWidth(-1.0), indexedCell.getHeight());
        }
    }

    private void setCellIndex(IndexedCell indexedCell, int n) {
        int n2 = indexedCell.getIndex();
        if (n2 != n) {
            indexedCell.updateIndex(n);
            indexedCell.impl_processCSS(false);
        }
    }

    private IndexedCell getAvailableCell(int n) {
        for (int i = 0; i < this.pile.size(); ++i) {
            IndexedCell indexedCell = this.pile.get(i);
            if (indexedCell == null || indexedCell.getIndex() != n) continue;
            this.pile.remove(i);
            return indexedCell;
        }
        if (this.pile.size() > 0) {
            return this.pile.removeFirst();
        }
        IndexedCell indexedCell = this.createCell.run();
        this.sheet.getChildren().add(indexedCell);
        return indexedCell;
    }

    private void addAllToPile() {
        while (this.cells.size() > 0) {
            this.addToPile(this.cells.removeFirst());
        }
    }

    private void addToPile(IndexedCell indexedCell) {
        indexedCell.setVisible(false);
        this.pile.addLast(indexedCell);
    }

    public IndexedCell getVisibleCell(int n) {
        if (this.cells.isEmpty()) {
            return null;
        }
        IndexedCell indexedCell = this.cells.getLast();
        int n2 = indexedCell.getIndex();
        if (n == n2) {
            return indexedCell;
        }
        IndexedCell indexedCell2 = this.cells.getFirst();
        int n3 = indexedCell2.getIndex();
        if (n == n3) {
            return indexedCell2;
        }
        if (n > n3 && n < n2) {
            return this.cells.get(n - n3);
        }
        return null;
    }

    public IndexedCell getLastVisibleCell() {
        if (this.cells.isEmpty() || this.viewportLength <= 0.0) {
            return null;
        }
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell indexedCell = this.cells.get(i);
            if (indexedCell.isEmpty()) continue;
            return indexedCell;
        }
        return null;
    }

    public IndexedCell getFirstVisibleCell() {
        if (this.cells.isEmpty() || this.viewportLength <= 0.0) {
            return null;
        }
        IndexedCell indexedCell = this.cells.getFirst();
        return indexedCell.isEmpty() ? null : indexedCell;
    }

    public IndexedCell getLastVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.viewportLength <= 0.0) {
            return null;
        }
        for (int i = this.cells.size() - 1; i >= 0; --i) {
            IndexedCell indexedCell = this.cells.get(i);
            if (indexedCell.isEmpty() || !(indexedCell.getLayoutY() < this.getHeight())) continue;
            return indexedCell;
        }
        return null;
    }

    public IndexedCell getFirstVisibleCellWithinViewPort() {
        if (this.cells.isEmpty() || this.viewportLength <= 0.0) {
            return null;
        }
        for (int i = 0; i < this.cells.size(); ++i) {
            IndexedCell indexedCell = this.cells.get(i);
            if (indexedCell.isEmpty() || !(indexedCell.getLayoutY() + indexedCell.getHeight() > 0.0)) continue;
            return indexedCell;
        }
        return null;
    }

    public void showAsFirst(IndexedCell indexedCell) {
        if (indexedCell != null) {
            this.adjustPixels(this.getCellPosition(indexedCell));
        }
    }

    public void showAsLast(IndexedCell indexedCell) {
        if (indexedCell != null) {
            this.adjustPixels(this.getCellPosition(indexedCell) + this.getCellLength(indexedCell) - this.viewportLength);
        }
    }

    public void show(IndexedCell indexedCell) {
        if (indexedCell != null) {
            double d = this.getCellPosition(indexedCell);
            double d2 = this.getCellLength(indexedCell);
            double d3 = d + d2;
            if (d < 0.0) {
                this.adjustPixels(d);
            } else if (d3 > this.viewportLength) {
                this.adjustPixels(d3 - this.viewportLength);
            }
        }
    }

    public void show(int n) {
        IndexedCell indexedCell = this.getVisibleCell(n);
        if (indexedCell != null) {
            this.show(indexedCell);
        } else {
            IndexedCell indexedCell2 = this.getVisibleCell(n - 1);
            if (indexedCell2 != null) {
                indexedCell = this.getAvailableCell(n);
                this.setCellIndex(indexedCell, n);
                this.resizeCellSize(indexedCell);
                this.cells.addLast(indexedCell);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell2) + this.getCellLength(indexedCell2));
                this.maxPrefBreadth = Math.max(this.maxPrefBreadth, this.getCellBreadth(indexedCell));
                indexedCell.setVisible(true);
                this.show(indexedCell);
                return;
            }
            IndexedCell indexedCell3 = this.getVisibleCell(n + 1);
            if (indexedCell3 != null) {
                indexedCell = this.getAvailableCell(n);
                this.setCellIndex(indexedCell, n);
                this.resizeCellSize(indexedCell);
                this.cells.addFirst(indexedCell);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell3) - this.getCellLength(indexedCell));
                this.maxPrefBreadth = Math.max(this.maxPrefBreadth, this.getCellBreadth(indexedCell));
                indexedCell.setVisible(true);
                this.show(indexedCell);
                return;
            }
            this.mapper.adjustPositionToIndex(n);
            this.addAllToPile();
            this.requestLayout();
        }
    }

    public double adjustPixels(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (this.isVertical() && !this.vbar.isVisible() || !this.isVertical() && !this.hbar.isVisible()) {
            return 0.0;
        }
        if (this.mapper.getPosition() == 0.0 && d < 0.0) {
            return 0.0;
        }
        if (this.mapper.getPosition() == 1.0 && d > 0.0) {
            return 0.0;
        }
        double d2 = this.mapper.getPosition();
        this.mapper.adjustByPixelAmount(d);
        if (d2 == this.mapper.getPosition()) {
            return 0.0;
        }
        if (this.cells.size() > 0) {
            for (int i = 0; i < this.cells.size(); ++i) {
                IndexedCell indexedCell = this.cells.get(i);
                this.positionCell(indexedCell, this.getCellPosition(indexedCell) - d);
            }
            IndexedCell indexedCell = this.cells.getFirst();
            int n = indexedCell.getIndex();
            double d3 = this.getCellLength(n - 1);
            this.addLeadingCells(n - 1, this.getCellPosition(indexedCell) - d3);
            if (!this.addTrailingCells(false)) {
                IndexedCell indexedCell2 = this.getLastVisibleCell();
                double d4 = this.getCellLength(indexedCell2);
                double d5 = this.getCellPosition(indexedCell2) + d4;
                if (d5 < this.viewportLength) {
                    double d6 = this.viewportLength - d5;
                    for (int i = 0; i < this.cells.size(); ++i) {
                        IndexedCell indexedCell3 = this.cells.get(i);
                        this.positionCell(indexedCell3, this.getCellPosition(indexedCell3) + d6);
                    }
                    this.mapper.adjustPosition(1.0);
                }
            }
            this.cull();
        }
        this.updateScrollBarsAndViewport(this.viewportLength);
        this.lastPosition = this.getPosition();
        return d;
    }

    public void reconfigureCells() {
        this.maxPrefBreadth = -1.0;
        this.lastWidth = -1.0;
        this.lastHeight = -1.0;
        this.requestLayout();
    }

    public void recreateCells() {
        this.maxPrefBreadth = -1.0;
        this.lastWidth = -1.0;
        this.lastHeight = -1.0;
        this.releaseCell(this.accumCell);
        this.accumCell = null;
        this.accumCellParent.getChildren().clear();
        this.addAllToPile();
        this.pile.clear();
        this.requestLayout();
    }

    private double getPrefBreadth() {
        double d = 0.0;
        int n = Math.min(10, this.getCellCount());
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.getCellBreadth(i));
        }
        double d2 = this.getPrefLength();
        d = Math.max(d, d2 * 0.618033987);
        return d;
    }

    private double getPrefLength() {
        double d = 0.0;
        int n = Math.min(10, this.getCellCount());
        for (int i = 0; i < n; ++i) {
            d += this.getCellLength(i);
        }
        return d;
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.isVertical() ? this.getPrefBreadth() : this.getPrefLength();
        return d2 + this.vbar.prefWidth(-1.0);
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = this.isVertical() ? this.getPrefLength() : this.getPrefBreadth();
        return d2 + this.hbar.prefHeight(-1.0);
    }

    static class ArrayLinkedList<T> {
        private final ArrayList<T> array = new ArrayList(50);
        private int firstIndex = -1;
        private int lastIndex = -1;

        public ArrayLinkedList() {
            for (int i = 0; i < 50; ++i) {
                this.array.add(null);
            }
        }

        public T getFirst() {
            return this.firstIndex == -1 ? null : (T)this.array.get(this.firstIndex);
        }

        public T getLast() {
            return this.lastIndex == -1 ? null : (T)this.array.get(this.lastIndex);
        }

        public void addFirst(T t) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.firstIndex, t);
            } else if (this.firstIndex == 0) {
                this.array.add(0, t);
                ++this.lastIndex;
            } else {
                this.array.set(--this.firstIndex, t);
            }
        }

        public void addLast(T t) {
            if (this.firstIndex == -1) {
                this.firstIndex = this.lastIndex = this.array.size() / 2;
                this.array.set(this.lastIndex, t);
            } else if (this.lastIndex == this.array.size() - 1) {
                this.array.add(++this.lastIndex, t);
            } else {
                this.array.set(++this.lastIndex, t);
            }
        }

        public int size() {
            return this.firstIndex == -1 ? 0 : this.lastIndex - this.firstIndex + 1;
        }

        public boolean isEmpty() {
            return this.firstIndex == -1;
        }

        public T get(int n) {
            if (n > this.lastIndex - this.firstIndex || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.array.get(this.firstIndex + n);
        }

        public void clear() {
            for (int i = 0; i < this.array.size(); ++i) {
                this.array.set(i, null);
            }
            this.lastIndex = -1;
            this.firstIndex = -1;
        }

        public T removeFirst() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(0);
        }

        public T removeLast() {
            if (this.isEmpty()) {
                return null;
            }
            return this.remove(this.lastIndex - this.firstIndex);
        }

        public T remove(int n) {
            if (n > this.lastIndex - this.firstIndex || n < 0) {
                throw new ArrayIndexOutOfBoundsException();
            }
            if (n == 0) {
                T t = this.array.get(this.firstIndex);
                this.array.set(this.firstIndex, null);
                if (this.firstIndex == this.lastIndex) {
                    this.lastIndex = -1;
                    this.firstIndex = -1;
                } else {
                    ++this.firstIndex;
                }
                return t;
            }
            if (n == this.lastIndex - this.firstIndex) {
                T t = this.array.get(this.lastIndex);
                this.array.set(this.lastIndex--, null);
                return t;
            }
            T t = this.array.get(this.firstIndex + n);
            this.array.set(this.firstIndex + n, null);
            for (int i = this.firstIndex + n + 1; i <= this.lastIndex; ++i) {
                this.array.set(i - 1, this.array.get(i));
            }
            this.array.set(this.lastIndex--, null);
            return t;
        }
    }

    static class ClippedContainer
    extends Region {
        private Node node;
        private final Group contentGroup;
        private final Rectangle clipRect;

        public Node getNode() {
            return this.node;
        }

        public void setNode(Node node) {
            this.node = node;
            this.contentGroup.getChildren().clear();
            this.contentGroup.getChildren().add(this.node);
        }

        public void setClipX(double d) {
            this.contentGroup.setLayoutX(-d);
        }

        public void setClipY(double d) {
            this.contentGroup.setLayoutY(-d);
        }

        public ClippedContainer(VirtualFlow virtualFlow) {
            if (virtualFlow == null) {
                throw new IllegalArgumentException("VirtualFlow can not be null");
            }
            this.clipRect = new Rectangle();
            this.clipRect.setSmooth(false);
            this.setClip(this.clipRect);
            this.contentGroup = new Group();
            this.getChildren().add(this.contentGroup);
            super.widthProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    ClippedContainer.this.clipRect.setWidth(ClippedContainer.this.getWidth());
                }
            });
            super.heightProperty().addListener(new InvalidationListener(){

                @Override
                public void invalidated(Observable observable) {
                    ClippedContainer.this.clipRect.setHeight(ClippedContainer.this.getHeight());
                }
            });
        }
    }
}

