/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import javafx.collections.MapChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.IndexedCell;

public abstract class VirtualContainerBase<C extends Control, B extends BehaviorBase<C>, I extends IndexedCell>
extends SkinBase<C, B> {
    public static final String SCROLL_TO_INDEX = "VirtualContainerBase.scrollToIndex";
    protected VirtualFlow flow;

    public VirtualContainerBase(C c, B b) {
        super(c, b);
        ((Node)c).getProperties().addListener(new MapChangeListener<Object, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                if (change.wasAdded() && VirtualContainerBase.SCROLL_TO_INDEX.equals(change.getKey())) {
                    Object object = change.getValueAdded();
                    if (object instanceof Integer) {
                        VirtualContainerBase.this.scrollTo((Integer)object);
                    }
                    change.getMap().remove(VirtualContainerBase.SCROLL_TO_INDEX);
                }
            }
        });
    }

    public abstract I createCell();

    public abstract int getItemCount();

    protected void scrollTo(int n) {
        if (n < 0 || this.getItemCount() == 0) {
            return;
        }
        boolean bl = false;
        if (n >= this.getItemCount() - 1) {
            this.flow.setPosition(1.0);
            bl = true;
        }
        if (!bl) {
            this.flow.setPosition((double)n / (double)this.getItemCount());
        }
        this.flow.requestLayout();
    }
}

