/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.runnable.Runnable0;
import com.sun.javafx.scene.control.WeakEventHandler;
import com.sun.javafx.scene.control.behavior.TreeViewBehavior;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import java.lang.ref.WeakReference;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class TreeViewSkin<T>
extends VirtualContainerBase<TreeView<T>, TreeViewBehavior<T>, TreeCell<T>> {
    private boolean needItemCountUpdate = false;
    private boolean needCellsRecreated = false;
    private EventHandler<TreeItem.TreeModificationEvent> rootListener = new EventHandler<TreeItem.TreeModificationEvent>(){

        @Override
        public void handle(TreeItem.TreeModificationEvent treeModificationEvent) {
            if (treeModificationEvent.wasAdded() && treeModificationEvent.wasRemoved() && treeModificationEvent.getAddedSize() == treeModificationEvent.getRemovedSize()) {
                TreeViewSkin.this.needItemCountUpdate = true;
                TreeViewSkin.this.requestLayout();
            } else if (treeModificationEvent.wasAdded() && treeModificationEvent.getAddedSize() == treeModificationEvent.getTreeItem().getChildren().size() || treeModificationEvent.wasRemoved() && treeModificationEvent.getTreeItem().getChildren().isEmpty()) {
                TreeViewSkin.this.needCellsRecreated = true;
                TreeViewSkin.this.requestLayout();
            } else if (treeModificationEvent.getEventType().equals(TreeItem.valueChangedEvent())) {
                TreeViewSkin.this.needCellsRecreated = true;
                TreeViewSkin.this.requestLayout();
            }
        }
    };
    private WeakEventHandler weakRootListener;
    private WeakReference<TreeItem> weakRoot;

    public TreeViewSkin(final TreeView treeView) {
        super(treeView, new TreeViewBehavior(treeView));
        this.flow = new VirtualFlow();
        this.flow.setPannable(false);
        this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        this.flow.setCreateCell((Runnable0<? extends IndexedCell>)new Runnable0<TreeCell>(){

            @Override
            public TreeCell run() {
                return TreeViewSkin.this.createCell();
            }
        });
        this.getChildren().add(this.flow);
        this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                if (treeView.getEditingItem() != null) {
                    treeView.edit(null);
                }
                treeView.requestFocus();
            }
        };
        this.flow.getVbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        this.flow.getHbar().addEventFilter(MouseEvent.MOUSE_PRESSED, eventHandler);
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToFirstCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToFirstCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnMoveToLastCell(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onMoveToLastCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageDown(new Callback<Void, Integer>(){

            @Override
            public Integer call(Void void_) {
                return TreeViewSkin.this.onScrollPageDown();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnScrollPageUp(new Callback<Void, Integer>(){

            @Override
            public Integer call(Void void_) {
                return TreeViewSkin.this.onScrollPageUp();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectPreviousRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectPreviousCell();
            }
        });
        ((TreeViewBehavior)this.getBehavior()).setOnSelectNextRow(new Runnable(){

            @Override
            public void run() {
                TreeViewSkin.this.onSelectNextCell();
            }
        });
        this.registerChangeListener(treeView.rootProperty(), "ROOT");
        this.registerChangeListener(treeView.showRootProperty(), "SHOW_ROOT");
        this.registerChangeListener(treeView.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(treeView.impl_treeItemCountProperty(), "TREE_ITEM_COUNT");
        this.registerChangeListener(treeView.focusTraversableProperty(), "FOCUS_TRAVERSABLE");
        this.updateItemCount();
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "ROOT") {
            this.setRoot(((TreeView)this.getSkinnable()).getRoot());
        } else if (string == "SHOW_ROOT") {
            if (!((TreeView)this.getSkinnable()).isShowRoot() && this.getRoot() != null) {
                this.getRoot().setExpanded(true);
                this.updateItemCount();
            }
        } else if (string == "CELL_FACTORY") {
            this.flow.recreateCells();
        } else if (string == "TREE_ITEM_COUNT") {
            this.updateItemCount();
        } else if (string == "FOCUS_TRAVERSABLE") {
            this.flow.setFocusTraversable(((TreeView)this.getSkinnable()).isFocusTraversable());
        }
    }

    private TreeItem getRoot() {
        return this.weakRoot == null ? null : (TreeItem)this.weakRoot.get();
    }

    private void setRoot(TreeItem treeItem) {
        if (this.getRoot() != null && this.weakRootListener != null) {
            this.getRoot().removeEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
        this.weakRoot = new WeakReference<TreeItem>(treeItem);
        if (this.getRoot() != null) {
            this.weakRootListener = new WeakEventHandler<TreeItem.TreeModificationEvent>(this.getRoot(), TreeItem.treeNotificationEvent(), this.rootListener);
            this.getRoot().addEventHandler(TreeItem.treeNotificationEvent(), this.weakRootListener);
        }
    }

    @Override
    public int getItemCount() {
        return ((TreeView)this.getSkinnable()).impl_getTreeItemCount();
    }

    private void updateItemCount() {
        for (int i = 0; i < this.flow.cells.size(); ++i) {
            ((TreeCell)this.flow.cells.get(i)).updateTreeView(null);
        }
        this.flow.setCellCount(this.getItemCount());
        this.flow.recreateCells();
    }

    @Override
    public TreeCell<T> createCell() {
        TreeCell<T> treeCell = ((TreeView)this.getSkinnable()).getCellFactory() != null ? ((TreeView)this.getSkinnable()).getCellFactory().call(this.getSkinnable()) : this.createDefaultCellImpl();
        if (treeCell.getDisclosureNode() == null) {
            StackPane stackPane = new StackPane();
            stackPane.getStyleClass().setAll((String[])new String[]{"tree-disclosure-node"});
            StackPane stackPane2 = new StackPane();
            stackPane2.getStyleClass().setAll((String[])new String[]{"arrow"});
            stackPane.getChildren().add(stackPane2);
            treeCell.setDisclosureNode(stackPane);
        }
        treeCell.updateTreeView((TreeView)this.getSkinnable());
        return treeCell;
    }

    private TreeCell<T> createDefaultCellImpl() {
        return new TreeCell(){
            private HBox hbox;

            @Override
            public void updateItem(Object object, boolean bl) {
                super.updateItem(object, bl);
                if (object == null || bl) {
                    this.hbox = null;
                    this.setText(null);
                    this.setGraphic(null);
                } else {
                    TreeItem treeItem = this.getTreeItem();
                    if (treeItem != null && treeItem.getGraphic() != null) {
                        if (object instanceof Node) {
                            this.setText(null);
                            if (this.hbox == null) {
                                this.hbox = new HBox(3.0);
                            }
                            this.hbox.getChildren().setAll((Node[])new Node[]{treeItem.getGraphic(), (Node)object});
                            this.setGraphic(this.hbox);
                        } else {
                            this.hbox = null;
                            this.setText(object.toString());
                            this.setGraphic(treeItem.getGraphic());
                        }
                    } else {
                        this.hbox = null;
                        if (object instanceof Node) {
                            this.setText(null);
                            this.setGraphic((Node)object);
                        } else {
                            this.setText(object.toString());
                            this.setGraphic(null);
                        }
                    }
                }
            }
        };
    }

    @Override
    protected double computePrefWidth(double d) {
        return 200.0;
    }

    @Override
    protected double computePrefHeight(double d) {
        return 400.0;
    }

    @Override
    protected void layoutChildren() {
        if (this.needCellsRecreated) {
            this.flow.recreateCells();
            this.needCellsRecreated = false;
        } else if (this.needItemCountUpdate) {
            this.updateItemCount();
            this.needItemCountUpdate = false;
        }
        super.layoutChildren();
    }

    private void onSelectPreviousCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onSelectNextCell() {
        int n = ((TreeView)this.getSkinnable()).getSelectionModel().getSelectedIndex();
        this.flow.show(n);
    }

    private void onMoveToFirstCell() {
        this.flow.show(0);
        this.flow.setPosition(0.0);
    }

    private void onMoveToLastCell() {
        this.flow.show(this.getItemCount());
        this.flow.setPosition(1.0);
    }

    public int onScrollPageDown() {
        IndexedCell indexedCell = this.flow.getLastVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n = -1;
        if (!indexedCell.isSelected() && !indexedCell.isFocused()) {
            n = indexedCell.getIndex();
        } else {
            this.flow.showAsFirst(indexedCell);
            indexedCell = this.flow.getLastVisibleCellWithinViewPort();
            n = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n;
    }

    public int onScrollPageUp() {
        IndexedCell indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
        if (indexedCell == null) {
            return -1;
        }
        int n = -1;
        if (!indexedCell.isSelected() && !indexedCell.isFocused()) {
            n = indexedCell.getIndex();
        } else {
            this.flow.showAsLast(indexedCell);
            indexedCell = this.flow.getFirstVisibleCellWithinViewPort();
            n = indexedCell.getIndex();
        }
        this.flow.show(indexedCell);
        return n;
    }
}

