/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.TitledPaneBehavior;
import com.sun.javafx.scene.control.skin.AccordionSkin;
import com.sun.javafx.scene.control.skin.LabeledImpl;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import javafx.animation.Animation;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class TitledPaneSkin
extends SkinBase<TitledPane, TitledPaneBehavior> {
    public static final int MIN_HEADER_HEIGHT = 22;
    public static final Duration TRANSITION_DURATION = new Duration(350.0);
    private final HBox titleRegion;
    private final StackPane arrowRegion;
    private final Content contentRegion;
    private Timeline timeline;
    private double transitionStartValue;
    private Rectangle clipRect;
    private LabeledImpl label;
    private DoubleProperty transition;

    public TitledPaneSkin(TitledPane titledPane) {
        super(titledPane, new TitledPaneBehavior(titledPane));
        this.label = new LabeledImpl(titledPane);
        this.label.getStyleClass().add("text");
        this.clipRect = new Rectangle();
        this.setClip(this.clipRect);
        this.transitionStartValue = 0.0;
        this.titleRegion = new HBox();
        this.titleRegion.setFillHeight(false);
        this.titleRegion.setAlignment(Pos.CENTER_LEFT);
        this.titleRegion.getStyleClass().setAll((String[])new String[]{"title"});
        this.titleRegion.getChildren().clear();
        this.titleRegion.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ((TitledPaneBehavior)TitledPaneSkin.this.getBehavior()).toggle();
            }
        });
        this.arrowRegion = new StackPane();
        this.arrowRegion.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        StackPane stackPane = new StackPane();
        stackPane.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrowRegion.getChildren().setAll((Node[])new Node[]{stackPane});
        this.updateTitleRegion();
        this.contentRegion = new Content(((TitledPane)this.getSkinnable()).getContent());
        this.contentRegion.getStyleClass().setAll((String[])new String[]{"content"});
        if (titledPane.isExpanded()) {
            this.setExpanded(titledPane.isExpanded());
        } else {
            this.setTransition(0.0);
        }
        this.getChildren().setAll((Node[])new Node[]{this.titleRegion, this.contentRegion});
        this.registerChangeListener(titledPane.contentProperty(), "CONTENT");
        this.registerChangeListener(titledPane.expandedProperty(), "EXPANDED");
        this.registerChangeListener(titledPane.collapsibleProperty(), "COLLAPSIBLE");
    }

    public StackPane getContentRegion() {
        return this.contentRegion;
    }

    @Override
    protected void setWidth(double d) {
        super.setWidth(d);
        this.clipRect.setWidth(d);
    }

    @Override
    protected void setHeight(double d) {
        super.setHeight(d);
        this.clipRect.setHeight(d);
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "CONTENT") {
            this.contentRegion.setContent(((TitledPane)this.getSkinnable()).getContent());
        } else if (string == "EXPANDED") {
            this.setExpanded(((TitledPane)this.getSkinnable()).isExpanded());
        } else if (string == "COLLAPSIBLE") {
            this.updateTitleRegion();
        }
    }

    private void updateTitleRegion() {
        this.titleRegion.getChildren().clear();
        if (((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.titleRegion.getChildren().add(this.arrowRegion);
        }
        this.titleRegion.getChildren().add(this.label);
        this.titleRegion.setCursor(((TitledPane)this.getSkinnable()).isCollapsible() ? Cursor.HAND : Cursor.DEFAULT);
    }

    private void setExpanded(boolean bl) {
        if (!((TitledPane)this.getSkinnable()).isCollapsible()) {
            this.setTransition(1.0);
            return;
        }
        if (((TitledPane)this.getSkinnable()).isAnimated()) {
            this.transitionStartValue = this.getTransition();
            this.doAnimationTransition();
        } else {
            if (bl) {
                this.setTransition(1.0);
            } else {
                this.setTransition(0.0);
            }
            this.contentRegion.setVisible(bl);
            this.requestLayout();
        }
    }

    private void setTransition(double d) {
        this.transitionProperty().set(d);
    }

    private double getTransition() {
        return this.transition == null ? 0.0 : this.transition.get();
    }

    private DoubleProperty transitionProperty() {
        if (this.transition == null) {
            this.transition = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    TitledPaneSkin.this.requestLayout();
                }

                @Override
                public Object getBean() {
                    return TitledPaneSkin.this;
                }

                @Override
                public String getName() {
                    return "transition";
                }
            };
        }
        return this.transition;
    }

    @Override
    protected void layoutChildren() {
        double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
        double d2 = Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
        this.titleRegion.resize(d, d2);
        this.positionInArea(this.titleRegion, this.snapSpace(this.getInsets().getLeft()), this.snapSpace(this.getInsets().getTop()), d, d2, 0.0, HPos.LEFT, VPos.CENTER);
        double d3 = d;
        double d4 = this.snapSize(this.contentRegion.prefHeight(-1.0) * this.getTransition());
        this.contentRegion.resize(d3, d4);
        this.positionInArea(this.contentRegion, this.snapSpace(this.getInsets().getLeft()), this.snapSpace(this.getInsets().getTop() + d2), d, d4, 0.0, HPos.CENTER, VPos.CENTER);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.computePrefWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    @Override
    protected double computePrefWidth(double d) {
        double d2 = this.snapSize(this.titleRegion.prefWidth(d));
        double d3 = this.snapSize(this.contentRegion.prefWidth(d));
        return Math.max(d2, d3) + this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = Math.max(22.0, this.snapSize(this.titleRegion.prefHeight(-1.0)));
        double d3 = 0.0;
        d3 = this.contentRegion.prefHeight(-1.0) * this.getTransition();
        return d2 + this.snapSize(d3) + this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((TitledPane)this.getSkinnable()).isExpanded() ? Double.MAX_VALUE : this.snapSize(((TitledPane)this.getSkinnable()).prefHeight(d));
    }

    private void doAnimationTransition() {
        KeyFrame keyFrame;
        KeyFrame keyFrame2;
        Duration duration;
        if (this.contentRegion.getContent() == null) {
            return;
        }
        if (this.timeline != null && this.timeline.getStatus() != Animation.Status.STOPPED) {
            duration = this.timeline.getCurrentTime();
            this.timeline.stop();
        } else {
            duration = TRANSITION_DURATION;
        }
        this.timeline = new Timeline();
        this.timeline.setCycleCount(1);
        if (((TitledPane)this.getSkinnable()).isExpanded()) {
            keyFrame2 = new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(true);
                    TitledPaneSkin.this.contentRegion.getContent().setVisible(true);
                }
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            keyFrame = new KeyFrame(duration, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 1, Interpolator.EASE_OUT));
        } else {
            keyFrame2 = new KeyFrame(Duration.ZERO, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setCache(true);
                }
            }, new KeyValue(this.transitionProperty(), this.transitionStartValue));
            keyFrame = new KeyFrame(duration, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    TitledPaneSkin.this.contentRegion.getContent().setVisible(false);
                    TitledPaneSkin.this.contentRegion.getContent().setCache(false);
                }
            }, new KeyValue(this.transitionProperty(), 0, Interpolator.EASE_IN));
        }
        this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{keyFrame2, keyFrame});
        this.timeline.play();
    }

    class Content
    extends StackPane
    implements TraverseListener {
        private Node content;
        private Rectangle clipRect = new Rectangle();
        private TraversalEngine engine;
        private Direction direction;

        public Content(Node node) {
            this.setClip(this.clipRect);
            this.content = node;
            if (node != null) {
                this.getChildren().add(node);
            }
            this.engine = new TraversalEngine(this, false){

                @Override
                public void trav(Node node, Direction direction) {
                    Content.this.direction = direction;
                    super.trav(node, direction);
                }
            };
            this.engine.addTraverseListener(this);
            this.setImpl_traversalEngine(this.engine);
        }

        public void setContent(Node node) {
            this.content = node;
            if (node != null) {
                this.getChildren().setAll((Node[])new Node[]{((TitledPane)TitledPaneSkin.this.getSkinnable()).getContent()});
            }
        }

        public Node getContent() {
            return this.content;
        }

        @Override
        protected void setWidth(double d) {
            super.setWidth(d);
            this.clipRect.setWidth(d);
        }

        @Override
        protected void setHeight(double d) {
            super.setHeight(d);
            this.clipRect.setHeight(d);
        }

        @Override
        protected void layoutChildren() {
            if (this.content != null) {
                double d = this.snapSize(this.getWidth()) - (this.snapSpace(this.getInsets().getLeft()) + this.snapSpace(this.getInsets().getRight()));
                double d2 = this.snapSize(this.getHeight()) - (this.snapSpace(this.getInsets().getTop()) + this.snapSpace(this.getInsets().getBottom()));
                double d3 = this.content.isManaged() ? this.snapSize(d) : this.snapSize(Math.min(d, this.content.prefWidth(-1.0)));
                double d4 = this.content.isManaged() ? this.snapSize(this.content.prefHeight(-1.0)) : this.snapSize(Math.min(d2, this.content.prefHeight(-1.0)));
                this.content.resize(d3, d4);
                this.positionInArea(this.content, this.snapSpace(this.getInsets().getLeft()), this.snapSpace(this.getInsets().getTop()), d3, d4, 0.0, HPos.CENTER, VPos.TOP);
            }
        }

        @Override
        public void onTraverse(Node node, Bounds bounds) {
            int n = this.engine.registeredNodes.indexOf(node);
            if (n == -1 && this.direction.equals((Object)Direction.PREVIOUS)) {
                ((TitledPane)TitledPaneSkin.this.getSkinnable()).requestFocus();
            }
            if (n == -1 && this.direction.equals((Object)Direction.NEXT) && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() != null && ((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent() instanceof AccordionSkin) {
                new TraversalEngine((Parent)((Object)TitledPaneSkin.this.getSkinnable()), false).trav(((TitledPane)TitledPaneSkin.this.getSkinnable()).getParent(), Direction.NEXT);
            }
        }
    }
}

