/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.WeakListChangeListener;
import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.resources.ControlResources;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;

class TableHeaderRow
extends StackPane {
    private static final String MENU_SEPARATOR = ControlResources.getString("TableView.nestedColumnControlMenuSeparator");
    private final VirtualFlow flow;
    private final TableView<?> table;
    private Insets tablePadding;
    private Region columnReorderLine;
    private double scrollX;
    private double tableWidth;
    private Rectangle clip;
    private BooleanProperty reorderingProperty = new BooleanPropertyBase(){

        @Override
        protected void invalidated() {
            TableColumnHeader tableColumnHeader = TableHeaderRow.this.getReorderingRegion();
            if (tableColumnHeader != null) {
                double d = tableColumnHeader.getNestedColumnHeader() != null ? tableColumnHeader.getNestedColumnHeader().getHeight() : TableHeaderRow.this.getReorderingRegion().getHeight();
                TableHeaderRow.this.dragHeader.resize(TableHeaderRow.this.dragHeader.getWidth(), d);
                TableHeaderRow.this.dragHeader.setTranslateY(TableHeaderRow.this.getHeight() - d);
            }
            TableHeaderRow.this.dragHeader.setVisible(TableHeaderRow.this.isReordering());
        }

        @Override
        public Object getBean() {
            return TableHeaderRow.this;
        }

        @Override
        public String getName() {
            return "reordering";
        }
    };
    private TableColumnHeader reorderingRegion;
    private StackPane dragHeader;
    private final Label dragHeaderLabel = new Label();
    private final NestedTableColumnHeader header;
    private Region filler;
    private Pane cornerRegion;
    private ContextMenu columnPopupMenu;
    private boolean headerDirty = false;
    private InvalidationListener tableWidthListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            TableHeaderRow.this.updateTableWidth();
        }
    };
    private ListChangeListener visibleLeafColumnsListener = new ListChangeListener<TableColumn<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<?, ?>> change) {
            TableHeaderRow.this.headerDirty = true;
            TableHeaderRow.this.requestLayout();
        }
    };
    private final ListChangeListener tableColumnsListener = new ListChangeListener<TableColumn<?, ?>>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends TableColumn<?, ?>> change) {
            while (change.next()) {
                TableHeaderRow.this.updateTableColumnListeners(change.getAddedSubList(), change.getRemoved());
            }
        }
    };
    private final WeakInvalidationListener weakTableWidthListener = new WeakInvalidationListener(this.tableWidthListener);
    private final WeakListChangeListener weakVisibleLeafColumnsListener = new WeakListChangeListener(this.visibleLeafColumnsListener);
    private final WeakListChangeListener weakTableColumnsListener = new WeakListChangeListener(this.tableColumnsListener);
    private Map<TableColumn, CheckMenuItem> columnMenuItems = new HashMap<TableColumn, CheckMenuItem>();

    VirtualFlow getVirtualFlow() {
        return this.flow;
    }

    public void setTablePadding(Insets insets) {
        this.tablePadding = insets;
        this.updateTableWidth();
    }

    public Insets getTablePadding() {
        return this.tablePadding == null ? Insets.EMPTY : this.tablePadding;
    }

    public Region getColumnReorderLine() {
        return this.columnReorderLine;
    }

    public void setColumnReorderLine(Region region) {
        this.columnReorderLine = region;
    }

    public double getTableWidth() {
        return this.tableWidth;
    }

    private void updateTableWidth() {
        double d = this.getTablePadding().getLeft() + this.getTablePadding().getRight();
        this.tableWidth = this.table.getWidth() - d;
        this.clip.setWidth(this.tableWidth);
    }

    public final void setReordering(boolean bl) {
        this.reorderingProperty().set(bl);
    }

    public final boolean isReordering() {
        return this.reorderingProperty.get();
    }

    public final BooleanProperty reorderingProperty() {
        return this.reorderingProperty;
    }

    public TableColumnHeader getReorderingRegion() {
        return this.reorderingRegion;
    }

    public void setReorderingColumn(TableColumn tableColumn) {
        this.dragHeaderLabel.setText(tableColumn == null ? "" : tableColumn.getText());
    }

    public void setReorderingRegion(TableColumnHeader tableColumnHeader) {
        this.reorderingRegion = tableColumnHeader;
        if (tableColumnHeader != null) {
            this.dragHeader.resize(tableColumnHeader.getWidth(), this.dragHeader.getHeight());
        }
    }

    public void setDragHeaderX(double d) {
        this.dragHeader.setTranslateX(d);
    }

    public TableHeaderRow(final TableView<?> tableView, VirtualFlow virtualFlow) {
        this.table = tableView;
        this.flow = virtualFlow;
        this.getStyleClass().setAll((String[])new String[]{"column-header-background"});
        InvalidationListener invalidationListener = new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TableHeaderRow.this.updateScrollX();
            }
        };
        virtualFlow.getHbar().valueProperty().addListener(invalidationListener);
        this.clip = new Rectangle();
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind(this.heightProperty());
        this.setClip(this.clip);
        this.updateTableWidth();
        tableView.widthProperty().addListener(this.weakTableWidthListener);
        tableView.getVisibleLeafColumns().addListener(this.weakVisibleLeafColumnsListener);
        this.columnPopupMenu = new ContextMenu();
        this.updateTableColumnListeners(tableView.getColumns(), Collections.emptyList());
        tableView.getColumns().addListener(this.weakTableColumnsListener);
        this.dragHeader = new StackPane();
        this.dragHeader.setVisible(false);
        this.dragHeader.getStyleClass().setAll((String[])new String[]{"column-drag-header"});
        this.dragHeader.setManaged(false);
        this.dragHeader.getChildren().add(this.dragHeaderLabel);
        this.header = new NestedTableColumnHeader(tableView, null);
        this.getChildren().add(0, this.header);
        this.header.setFocusTraversable(false);
        this.header.setTableHeaderRow(this);
        this.filler = new Region();
        this.filler.getStyleClass().setAll((String[])new String[]{"filler"});
        this.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                tableView.requestFocus();
            }
        });
        final StackPane stackPane = new StackPane();
        stackPane.setSnapToPixel(false);
        stackPane.getStyleClass().setAll((String[])new String[]{"show-hide-column-image"});
        this.cornerRegion = new StackPane(){

            @Override
            protected void layoutChildren() {
                Insets insets = stackPane.getInsets();
                double d = insets.getLeft() + insets.getRight();
                double d2 = insets.getTop() + insets.getBottom();
                stackPane.resize(d, d2);
                this.positionInArea(stackPane, 0.0, 0.0, this.getWidth(), this.getHeight() - 3.0, 0.0, HPos.CENTER, VPos.CENTER);
            }
        };
        this.cornerRegion.getStyleClass().setAll((String[])new String[]{"show-hide-columns-button"});
        this.cornerRegion.getChildren().addAll((Node[])new Node[]{stackPane});
        this.cornerRegion.setVisible(tableView.isTableMenuButtonVisible());
        tableView.tableMenuButtonVisibleProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                TableHeaderRow.this.cornerRegion.setVisible(tableView.isTableMenuButtonVisible());
                TableHeaderRow.this.requestLayout();
            }
        });
        this.cornerRegion.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                TableHeaderRow.this.columnPopupMenu.show(TableHeaderRow.this.cornerRegion, Side.BOTTOM, 0.0, 0.0);
            }
        });
        this.getChildren().addAll((Node[])new Node[]{this.filler, this.cornerRegion, this.dragHeader});
    }

    private void updateTableColumnListeners(List<? extends TableColumn<?, ?>> list, List<? extends TableColumn<?, ?>> list2) {
        for (TableColumn<?, ?> tableColumn : list2) {
            this.remove(tableColumn);
        }
        for (TableColumn<?, ?> tableColumn : list) {
            this.add(tableColumn);
        }
    }

    private void remove(TableColumn<?, ?> tableColumn) {
        if (tableColumn == null) {
            return;
        }
        if (tableColumn.getColumns().isEmpty()) {
            CheckMenuItem checkMenuItem = this.columnMenuItems.remove(tableColumn);
            checkMenuItem.textProperty().unbind();
            checkMenuItem.selectedProperty().unbindBidirectional(tableColumn.visibleProperty());
            this.columnPopupMenu.getItems().remove(checkMenuItem);
        } else {
            for (TableColumn tableColumn2 : tableColumn.getColumns()) {
                this.remove(tableColumn2);
            }
        }
    }

    private void add(final TableColumn<?, ?> tableColumn) {
        if (tableColumn == null) {
            return;
        }
        if (tableColumn.getColumns().isEmpty()) {
            CheckMenuItem checkMenuItem = this.columnMenuItems.get(tableColumn);
            if (checkMenuItem == null) {
                checkMenuItem = new CheckMenuItem();
                this.columnMenuItems.put(tableColumn, checkMenuItem);
            }
            checkMenuItem.textProperty().bind(new StringBinding(){
                {
                    super.bind(tableColumn.textProperty());
                }

                @Override
                protected String computeValue() {
                    return TableHeaderRow.this.getText(tableColumn.getText(), tableColumn);
                }
            });
            checkMenuItem.selectedProperty().bindBidirectional(tableColumn.visibleProperty());
            this.columnPopupMenu.getItems().add(checkMenuItem);
        } else {
            for (TableColumn tableColumn2 : tableColumn.getColumns()) {
                this.add(tableColumn2);
            }
        }
    }

    private void updateScrollX() {
        this.scrollX = this.flow.getHbar().isVisible() ? -this.flow.getHbar().getValue() : 0.0;
        this.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        if (this.headerDirty) {
            this.header.setColumns(this.table.getColumns());
            this.headerDirty = false;
        }
        double d = this.scrollX;
        double d2 = this.snapSize(this.header.prefWidth(-1.0));
        double d3 = this.getHeight() - this.getInsets().getTop() - this.getInsets().getBottom();
        double d4 = this.snapSize(this.flow.getVbar().prefWidth(-1.0));
        this.header.resizeRelocate(d, this.getInsets().getTop(), d2, d3);
        double d5 = this.filler.getBoundsInLocal().getWidth() - this.filler.getLayoutBounds().getWidth();
        double d6 = this.tableWidth - d2 + d5;
        this.filler.setVisible((d6 -= this.table.isTableMenuButtonVisible() ? d4 : 0.0) > 0.0);
        if (d6 > 0.0) {
            this.filler.resizeRelocate(d + d2, this.getInsets().getTop(), d6, d3);
        }
        this.cornerRegion.resizeRelocate(this.tableWidth - d4, this.getInsets().getTop(), d4, d3);
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.header.prefWidth(d);
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.computePrefHeight(d);
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.getInsets().getTop() + this.header.prefHeight(d) + this.getInsets().getBottom();
    }

    private String getText(String string, TableColumn tableColumn) {
        String string2 = string;
        for (TableColumn tableColumn2 = tableColumn.getParentColumn(); tableColumn2 != null; tableColumn2 = tableColumn2.getParentColumn()) {
            if (!this.isColumnVisibleInHeader(tableColumn2, this.table.getColumns())) continue;
            string2 = tableColumn2.getText() + MENU_SEPARATOR + string2;
        }
        return string2;
    }

    private boolean isColumnVisibleInHeader(TableColumn tableColumn, List list) {
        if (tableColumn == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            TableColumn tableColumn2 = (TableColumn)list.get(i);
            if (tableColumn.equals(tableColumn2)) {
                return true;
            }
            if (tableColumn2.getColumns().isEmpty() || !(bl = this.isColumnVisibleInHeader(tableColumn, tableColumn2.getColumns()))) continue;
            return true;
        }
        return false;
    }
}

