/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.runnable.Runnable1;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;

public class PositionMapper {
    private ReadOnlyDoubleWrapper position;
    private DoubleProperty viewportSize;
    private IntegerProperty itemCount;
    private Runnable1<Double, Integer> itemSize;

    private void setPosition(double d) {
        this.positionPropertyImpl().set(d);
    }

    public final double getPosition() {
        return this.position == null ? 0.0 : this.position.get();
    }

    public final ReadOnlyDoubleProperty positionProperty() {
        return this.positionPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyDoubleWrapper positionPropertyImpl() {
        if (this.position == null) {
            this.position = new ReadOnlyDoubleWrapper(this, "position");
        }
        return this.position;
    }

    public final void setViewportSize(double d) {
        this.viewportSizeProperty().set(d);
    }

    public final double getViewportSize() {
        return this.viewportSize == null ? 0.0 : this.viewportSize.get();
    }

    public final DoubleProperty viewportSizeProperty() {
        if (this.viewportSize == null) {
            this.viewportSize = new SimpleDoubleProperty(this, "viewportSize");
        }
        return this.viewportSize;
    }

    public final void setItemCount(int n) {
        this.itemCountProperty().set(n);
    }

    public final int getItemCount() {
        return this.itemCount == null ? 0 : this.itemCount.get();
    }

    public final IntegerProperty itemCountProperty() {
        if (this.itemCount == null) {
            this.itemCount = new SimpleIntegerProperty(this, "itemCount");
        }
        return this.itemCount;
    }

    private Runnable1<Double, Integer> getItemSize() {
        return this.itemSize;
    }

    public void setGetItemSize(Runnable1<Double, Integer> runnable1) {
        this.itemSize = runnable1;
    }

    public double computeViewportOffset(double d) {
        double d2 = Utils.clamp(0.0, d, 1.0);
        int n = this.getItemCount();
        double d3 = d2 * (double)n;
        int n2 = (int)d3;
        double d4 = d3 - (double)n2;
        double d5 = this.getItemSize().run(n2);
        double d6 = d5 * d4;
        double d7 = this.getViewportSize() * d2;
        return d6 - d7;
    }

    public void adjustPosition(double d) {
        this.setPosition(Utils.clamp(0.0, d, 1.0));
    }

    public void adjustPositionToIndex(int n) {
        if (this.getItemCount() <= 0) {
            this.setPosition(0.0);
        } else {
            this.adjustPosition((double)n / (double)this.getItemCount());
        }
    }

    public void adjustByPixelAmount(double d) {
        double d2;
        if (d == 0.0) {
            return;
        }
        boolean bl = d > 0.0;
        int n = this.getItemCount();
        double d3 = this.getPosition() * (double)n;
        int n2 = (int)d3;
        if (bl && n2 == n) {
            return;
        }
        double d4 = this.getItemSize().run(n2);
        double d5 = d3 - (double)n2;
        double d6 = d4 * d5;
        double d7 = 1.0 / (double)n;
        double d8 = this.computeOffsetForCell(n2);
        double d9 = d4 + this.computeOffsetForCell(n2 + 1);
        double d10 = d9 - d8;
        double d11 = d7 * (double)n2;
        for (d2 = bl ? d + d6 - this.getViewportSize() * this.getPosition() - d8 : -d + d9 - (d6 - this.getViewportSize() * this.getPosition()); d2 > d10 && (bl && n2 < n - 1 || !bl && n2 > 0); d2 -= d10) {
            n2 = bl ? ++n2 : --n2;
            d4 = this.getItemSize().run(n2);
            d8 = this.computeOffsetForCell(n2);
            d9 = d4 + this.computeOffsetForCell(n2 + 1);
            d10 = d9 - d8;
            d11 = d7 * (double)n2;
        }
        if (d2 > d10) {
            this.setPosition(bl ? 1.0 : 0.0);
        } else if (bl) {
            double d12 = d7 / Math.abs(d9 - d8);
            this.setPosition(d11 + d12 * d2);
        } else {
            double d13 = d7 / Math.abs(d9 - d8);
            this.setPosition(d11 + d7 - d13 * d2);
        }
    }

    public int computeCurrentIndex() {
        return (int)(this.getPosition() * (double)this.getItemCount());
    }

    public double computeOffsetForCell(int n) {
        double d = this.getItemCount();
        double d2 = Utils.clamp(0.0, (double)n, d) / d;
        return -(this.getViewportSize() * d2);
    }
}

