/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.MenuButtonBehaviorBase;
import com.sun.javafx.scene.control.skin.LabeledImpl;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public abstract class MenuButtonSkinBase<C extends MenuButton, B extends MenuButtonBehaviorBase<C>>
extends SkinBase<C, B> {
    protected final LabeledImpl label;
    protected final StackPane arrow;
    protected final StackPane arrowButton;
    protected final ContextMenu popup;
    protected boolean behaveLikeButton = false;

    public MenuButtonSkinBase(C c, B b) {
        super(c, b);
        if (((Node)c).getOnMousePressed() == null) {
            ((Node)c).setOnMousePressed((EventHandler<MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((MenuButtonBehaviorBase)MenuButtonSkinBase.this.getBehavior()).mousePressed(mouseEvent, MenuButtonSkinBase.this.behaveLikeButton);
                }
            });
        }
        if (((Node)c).getOnMouseReleased() == null) {
            ((Node)c).setOnMouseReleased((EventHandler<MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((MenuButtonBehaviorBase)MenuButtonSkinBase.this.getBehavior()).mouseReleased(mouseEvent, MenuButtonSkinBase.this.behaveLikeButton);
                }
            });
        }
        this.label = new MenuLabeledImpl((MenuButton)this.getSkinnable());
        this.label.setMnemonicParsing(((Labeled)c).isMnemonicParsing());
        this.label.setLabelFor((Node)c);
        this.label.setFocusTraversable(true);
        this.arrow = new StackPane();
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.popup = new ContextMenu();
        this.popup.getItems().clear();
        this.popup.getItems().addAll((Collection<MenuItem>)((MenuButton)this.getSkinnable()).getItems());
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.label, this.arrowButton});
        this.requestLayout();
        ((MenuButton)c).getItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                while (change.next()) {
                    MenuButtonSkinBase.this.popup.getItems().removeAll(change.getRemoved());
                    MenuButtonSkinBase.this.popup.getItems().addAll(change.getFrom(), change.getAddedSubList());
                }
            }
        });
        if (((MenuButton)this.getSkinnable()).getScene() != null) {
            this.addAccelerators();
        }
        ((Node)c).sceneProperty().addListener(new ChangeListener<Scene>(){

            @Override
            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (((MenuButton)MenuButtonSkinBase.this.getSkinnable()).getScene() != null) {
                    MenuButtonSkinBase.this.addAccelerators();
                }
            }
        });
        this.registerChangeListener(((MenuButton)c).showingProperty(), "SHOWING");
        this.registerChangeListener(((Node)c).focusedProperty(), "FOCUSED");
        this.registerChangeListener(((Labeled)c).mnemonicParsingProperty(), "MNEMONIC_PARSING");
        this.registerChangeListener(this.popup.showingProperty(), "POPUP_VISIBLE");
    }

    private void show() {
        if (!this.popup.isShowing()) {
            this.popup.show((Node)((Object)this.getSkinnable()), ((MenuButton)this.getSkinnable()).getPopupSide(), 0.0, 0.0);
        }
    }

    private void hide() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if (string == "SHOWING") {
            if (((MenuButton)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if (string == "FOCUSED") {
            if (!((MenuButton)this.getSkinnable()).isFocused() && ((MenuButton)this.getSkinnable()).isShowing()) {
                this.hide();
            }
            if (!((MenuButton)this.getSkinnable()).isFocused() && this.popup.isShowing()) {
                this.hide();
            }
        } else if (string == "POPUP_VISIBLE") {
            if (!this.popup.isShowing() && ((MenuButton)this.getSkinnable()).isShowing()) {
                ((MenuButton)this.getSkinnable()).hide();
            }
            if (this.popup.isShowing()) {
                Utils.addMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene());
            } else {
                Utils.removeMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene());
            }
        } else if (string == "MNEMONIC_PARSING") {
            this.label.setMnemonicParsing(((MenuButton)this.getSkinnable()).isMnemonicParsing());
            this.requestLayout();
        }
    }

    @Override
    protected double computePrefWidth(double d) {
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        return insets.getLeft() + this.label.prefWidth(d) + insets2.getLeft() + this.arrow.prefWidth(d) + insets2.getRight() + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        return insets.getTop() + Math.max(this.label.prefHeight(d), insets2.getTop() + this.arrow.prefHeight(-1.0) + insets2.getBottom()) + insets.getBottom();
    }

    @Override
    protected double computeMaxWidth(double d) {
        return ((MenuButton)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((MenuButton)this.getSkinnable()).prefHeight(d);
    }

    @Override
    protected void layoutChildren() {
        Insets insets = this.getInsets();
        Insets insets2 = this.arrowButton.getInsets();
        double d = insets.getLeft();
        double d2 = insets.getTop();
        double d3 = this.getWidth() - (insets.getLeft() + insets.getRight());
        double d4 = this.getHeight() - (insets.getTop() + insets.getBottom());
        double d5 = this.arrow.prefWidth(-1.0);
        double d6 = insets2.getLeft() + d5 + insets2.getRight();
        this.label.resizeRelocate(d, d2, d3 - d6, d4);
        this.arrowButton.resize(d6, d4);
        this.positionInArea(this.arrowButton, this.getWidth() - insets.getRight() - d6, d2, d6, d4, 0.0, HPos.CENTER, VPos.CENTER);
    }

    private void addAccelerators() {
        for (final MenuItem menuItem : this.popup.getItems()) {
            if (menuItem.getAccelerator() == null || ((MenuButton)this.getSkinnable()).getScene().getAccelerators() == null) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    menuItem.fire();
                }
            };
            ((MenuButton)this.getSkinnable()).getScene().getAccelerators().put(menuItem.getAccelerator(), runnable);
        }
    }

    private class MenuLabeledImpl
    extends LabeledImpl {
        MenuButton button;

        public MenuLabeledImpl(MenuButton menuButton) {
            super(menuButton);
            this.button = menuButton;
            this.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    MenuLabeledImpl.this.button.fireEvent(new ActionEvent());
                    actionEvent.consume();
                }
            });
        }

        public void fire() {
            this.button.fire();
        }
    }
}

