/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.SkinBase;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;

public class MenuBarSkin
extends SkinBase<MenuBar, BehaviorBase<MenuBar>>
implements TraverseListener {
    private final HBox container;
    private Menu openMenu;
    private MenuBarButton openMenuButton;
    private int focusedMenuIndex = 0;
    private TraversalEngine engine;
    private Direction direction;
    Runnable firstMenuRunnable = new Runnable(){

        @Override
        public void run() {
            if (MenuBarSkin.this.container.getChildren().size() > 0 && MenuBarSkin.this.container.getChildren().get(0) instanceof MenuButton) {
                ((Node)MenuBarSkin.this.container.getChildren().get(0)).requestFocus();
            }
        }
    };
    private boolean pendingDismiss = false;

    public MenuBarSkin(MenuBar menuBar) {
        super(menuBar, new BehaviorBase<MenuBar>(menuBar));
        this.container = new HBox();
        this.getChildren().add(this.container);
        this.rebuildUI();
        menuBar.getMenus().addListener(new ListChangeListener<Menu>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Menu> change) {
                MenuBarSkin.this.rebuildUI();
            }
        });
        KeyCode keyCode = KeyCode.F10;
        KeyCodeCombination keyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
        ((MenuBar)this.getSkinnable()).getParent().getScene().getAccelerators().put(keyCodeCombination, this.firstMenuRunnable);
        this.engine = new TraversalEngine(this, false){

            @Override
            public void trav(Node node, Direction direction) {
                MenuBarSkin.this.direction = direction;
                super.trav(node, direction);
            }
        };
        this.engine.addTraverseListener(this);
        this.setImpl_traversalEngine(this.engine);
    }

    private void rebuildUI() {
        MenuBarButton menuBarButton;
        for (Node eventTarget : this.container.getChildren()) {
            menuBarButton = (MenuBarButton)eventTarget;
            menuBarButton.menu.showingProperty().removeListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().unbind();
            menuBarButton.textProperty().unbind();
            menuBarButton.graphicProperty().unbind();
            menuBarButton.styleProperty().unbind();
        }
        this.container.getChildren().clear();
        for (final Menu menu : ((MenuBar)this.getSkinnable()).getMenus()) {
            menuBarButton = new MenuBarButton(menu.getText(), menu.getGraphic());
            menuBarButton.getStyleClass().add("menu");
            menuBarButton.setStyle(menu.getStyle());
            menuBarButton.getItems().setAll((Collection<MenuItem>)menu.getItems());
            this.container.getChildren().add(menuBarButton);
            menu.getItems().addListener(new ListChangeListener(){

                public void onChanged(ListChangeListener.Change change) {
                    while (change.next()) {
                        menuBarButton.getItems().removeAll(change.getRemoved());
                        menuBarButton.getItems().addAll(change.getFrom(), change.getAddedSubList());
                    }
                }
            });
            menuBarButton.menuListener = new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (menu.isShowing()) {
                        menuBarButton.show();
                    } else {
                        menuBarButton.hide();
                    }
                }
            };
            menuBarButton.menu = menu;
            menu.showingProperty().addListener(menuBarButton.menuListener);
            menuBarButton.disableProperty().bindBidirectional(menu.disableProperty());
            menuBarButton.textProperty().bind(menu.textProperty());
            menuBarButton.graphicProperty().bind(menu.graphicProperty());
            menuBarButton.styleProperty().bind(menu.styleProperty());
            menuBarButton.getProperties().addListener(new MapChangeListener<Object, Object>(){

                @Override
                public void onChanged(MapChangeListener.Change<? extends Object, ? extends Object> change) {
                    if (change.wasAdded() && "autoHide".equals(change.getKey())) {
                        menuBarButton.getProperties().remove("autoHide");
                        menu.hide();
                    }
                }
            });
            menuBarButton.showingProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        MenuBarSkin.this.openMenuButton = menuBarButton;
                        MenuBarSkin.this.openMenu = menu;
                    }
                }
            });
            menuBarButton.setOnMousePressed((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    MenuBarSkin.this.pendingDismiss = menuBarButton.isShowing();
                    if (menuBarButton.getScene().getWindow().isFocused()) {
                        if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                            MenuBarSkin.this.openMenu = menu;
                            MenuBarSkin.this.openMenu.show();
                        } else {
                            MenuBarSkin.this.openMenu = null;
                        }
                    }
                }
            });
            menuBarButton.setOnMouseReleased((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (menuBarButton.getScene().getWindow().isFocused() && MenuBarSkin.this.pendingDismiss) {
                        menuBarButton.hide();
                    }
                    MenuBarSkin.this.pendingDismiss = false;
                }
            });
            menuBarButton.setOnKeyPressed((EventHandler<? super KeyEvent>)new EventHandler<KeyEvent>(){

                @Override
                public void handle(KeyEvent keyEvent) {
                    switch (keyEvent.getCode()) {
                        case LEFT: {
                            if (menuBarButton.getScene().getWindow().isFocused()) {
                                Menu menu = MenuBarSkin.this.findPreviousSibling();
                                if (MenuBarSkin.this.openMenu == null || !MenuBarSkin.this.openMenu.isShowing()) {
                                    return;
                                }
                                if (MenuBarSkin.this.focusedMenuIndex == MenuBarSkin.this.container.getChildren().size() - 1) {
                                    ((MenuBarButton)MenuBarSkin.this.container.getChildren().get(MenuBarSkin.this.focusedMenuIndex)).requestFocus();
                                }
                                MenuBarSkin.this.openMenu.hide();
                                if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                                    MenuBarSkin.this.openMenu = menu;
                                    MenuBarSkin.this.openMenu.show();
                                } else {
                                    MenuBarSkin.this.openMenu = null;
                                }
                            }
                            keyEvent.consume();
                            break;
                        }
                        case RIGHT: {
                            if (menuBarButton.getScene().getWindow().isFocused()) {
                                Menu menu = MenuBarSkin.this.findNextSibling();
                                if (MenuBarSkin.this.openMenu == null || !MenuBarSkin.this.openMenu.isShowing()) {
                                    return;
                                }
                                if (MenuBarSkin.this.focusedMenuIndex == 0) {
                                    ((MenuBarButton)MenuBarSkin.this.container.getChildren().get(MenuBarSkin.this.focusedMenuIndex)).requestFocus();
                                }
                                MenuBarSkin.this.openMenu.hide();
                                if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                                    MenuBarSkin.this.openMenu = menu;
                                    MenuBarSkin.this.openMenu.show();
                                } else {
                                    MenuBarSkin.this.openMenu = null;
                                }
                            }
                            keyEvent.consume();
                            break;
                        }
                        case DOWN: 
                        case SPACE: 
                        case ENTER: {
                            if (!menuBarButton.getScene().getWindow().isFocused() || MenuBarSkin.this.focusedMenuIndex == -1) break;
                            if (!MenuBarSkin.this.isMenuEmpty((Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(MenuBarSkin.this.focusedMenuIndex))) {
                                MenuBarSkin.this.openMenu = (Menu)((MenuBar)MenuBarSkin.this.getSkinnable()).getMenus().get(MenuBarSkin.this.focusedMenuIndex);
                                MenuBarSkin.this.openMenu.show();
                            } else {
                                MenuBarSkin.this.openMenu = null;
                            }
                            keyEvent.consume();
                        }
                    }
                }
            });
            menuBarButton.setOnMouseEntered((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (menuBarButton.getScene().getWindow().isFocused()) {
                        if (MenuBarSkin.this.openMenu == null || !MenuBarSkin.this.openMenu.isShowing()) {
                            MenuBarSkin.this.updateFocusedIndex();
                            if (MenuBarSkin.this.isAnyMenuSelected()) {
                                menuBarButton.requestFocus();
                            }
                            return;
                        }
                        MenuBarSkin.this.openMenu.hide();
                        if (!MenuBarSkin.this.isMenuEmpty(menu)) {
                            MenuBarSkin.this.openMenu = menu;
                            MenuBarSkin.this.openMenuButton = menuBarButton;
                            MenuBarSkin.this.updateFocusedIndex();
                            MenuBarSkin.this.openMenuButton.requestFocus();
                            MenuBarSkin.this.openMenu.show();
                        } else {
                            MenuBarSkin.this.openMenu = null;
                        }
                    }
                }
            });
        }
        this.requestLayout();
    }

    private boolean isMenuEmpty(Menu menu) {
        boolean bl = true;
        for (MenuItem menuItem : menu.getItems()) {
            if (!menuItem.isVisible()) continue;
            bl = false;
        }
        return bl;
    }

    private boolean isAnyMenuSelected() {
        if (this.container != null) {
            for (Node node : this.container.getChildren()) {
                if (!((MenuButton)node).isFocused()) continue;
                return true;
            }
        }
        return false;
    }

    private Menu findPreviousSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == 0 ? this.container.getChildren().size() - 1 : --this.focusedMenuIndex;
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private Menu findNextSibling() {
        if (this.focusedMenuIndex == -1) {
            return null;
        }
        this.focusedMenuIndex = this.focusedMenuIndex == this.container.getChildren().size() - 1 ? 0 : ++this.focusedMenuIndex;
        this.clearMenuButtonHover();
        return (Menu)((MenuBar)this.getSkinnable()).getMenus().get(this.focusedMenuIndex);
    }

    private void updateFocusedIndex() {
        int n = 0;
        for (Node node : this.container.getChildren()) {
            if (node.isHover()) {
                this.focusedMenuIndex = n;
                return;
            }
            ++n;
        }
    }

    private void clearMenuButtonHover() {
        for (Node node : this.container.getChildren()) {
            if (!node.isHover()) continue;
            ((MenuBarButton)node).clearHover();
            return;
        }
    }

    @Override
    public void onTraverse(Node node, Bounds bounds) {
        if (this.direction.equals((Object)Direction.NEXT)) {
            if (this.openMenu != null) {
                this.openMenu.hide();
            }
            this.focusedMenuIndex = 0;
            new TraversalEngine((Parent)((Object)this.getSkinnable()), false).trav((Node)((Object)this.getSkinnable()), Direction.NEXT);
        } else if (this.direction.equals((Object)Direction.DOWN)) {
            // empty if block
        }
    }

    @Override
    protected void layoutChildren() {
        double d = this.getInsets().getLeft();
        double d2 = this.getInsets().getTop();
        double d3 = this.getWidth() - (this.getInsets().getLeft() + this.getInsets().getRight());
        double d4 = this.getHeight() - (this.getInsets().getTop() + this.getInsets().getBottom());
        this.container.resizeRelocate(d, d2, d3, d4);
    }

    @Override
    protected double computeMinWidth(double d) {
        return this.container.minWidth(d) + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computePrefWidth(double d) {
        return this.container.prefWidth(d) + this.getInsets().getLeft() + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        return this.container.minHeight(d) + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefHeight(double d) {
        return this.container.prefHeight(d) + this.getInsets().getTop() + this.getInsets().getBottom();
    }

    @Override
    protected double computeMaxHeight(double d) {
        return ((MenuBar)this.getSkinnable()).prefHeight(-1.0);
    }

    class MenuBarButton
    extends MenuButton {
        private ChangeListener<Boolean> menuListener;
        private Menu menu;

        public MenuBarButton() {
        }

        public MenuBarButton(String string) {
            super(string);
        }

        public MenuBarButton(String string, Node node) {
            super(string, node);
        }

        private void clearHover() {
            this.setHover(false);
        }
    }
}

