/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import com.sun.javafx.scene.control.skin.KeyCodeUtils;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class KeystrokeUtils {
    public static String toString(KeyCombination keyCombination) {
        if (keyCombination == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (Utils.isMac()) {
            if (keyCombination.getControl() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2303");
            }
            if (keyCombination.getAlt() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2325");
            }
            if (keyCombination.getShift() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u21e7");
            }
            if (keyCombination.getMeta() == KeyCombination.ModifierValue.DOWN) {
                stringBuilder.append("\u2318");
            }
            String string = "";
            if (keyCombination instanceof KeyCodeCombination) {
                KeyCode keyCode = ((KeyCodeCombination)keyCombination).getCode();
                string = KeyCodeUtils.getAccelerator(keyCode);
            } else if (keyCombination instanceof KeyCharacterCombination) {
                string = ((KeyCharacterCombination)keyCombination).getCharacter();
            }
            return keyCombination.getName() + string;
        }
        return keyCombination.getName();
    }
}

