/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import javafx.scene.input.KeyCode;

public class KeyCodeUtils {
    public static String getAccelerator(KeyCode keyCode) {
        String[] stringArray;
        char c = KeyCodeUtils.getSingleChar(keyCode);
        if (c != '\u0000') {
            return String.valueOf(c);
        }
        String string = keyCode.toString();
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = Utils.split(string, "_")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2.charAt(0));
            stringBuilder.append(string2.substring(1).toLowerCase());
        }
        return stringBuilder.toString();
    }

    private static char getSingleChar(KeyCode keyCode) {
        switch (keyCode) {
            case ENTER: {
                return '\u21b5';
            }
            case BACK_SPACE: {
                return '\u232b';
            }
            case ESCAPE: {
                return '\u238b';
            }
            case LEFT: {
                return '\u2190';
            }
            case UP: {
                return '\u2191';
            }
            case RIGHT: {
                return '\u2192';
            }
            case DOWN: {
                return '\u2193';
            }
            case COMMA: {
                return ',';
            }
            case MINUS: {
                return '-';
            }
            case PERIOD: {
                return '.';
            }
            case SLASH: {
                return '/';
            }
            case SEMICOLON: {
                return ';';
            }
            case EQUALS: {
                return '=';
            }
            case OPEN_BRACKET: {
                return '[';
            }
            case BACK_SLASH: {
                return '\\';
            }
            case CLOSE_BRACKET: {
                return ']';
            }
            case MULTIPLY: {
                return '*';
            }
            case ADD: {
                return '+';
            }
            case SUBTRACT: {
                return '-';
            }
            case DECIMAL: {
                return '.';
            }
            case DIVIDE: {
                return '/';
            }
            case DELETE: {
                return '\u2326';
            }
            case BACK_QUOTE: {
                return '`';
            }
            case QUOTE: {
                return '\"';
            }
            case AMPERSAND: {
                return '&';
            }
            case ASTERISK: {
                return '*';
            }
            case LESS: {
                return '<';
            }
            case GREATER: {
                return '>';
            }
            case BRACELEFT: {
                return '{';
            }
            case BRACERIGHT: {
                return '}';
            }
            case AT: {
                return '@';
            }
            case COLON: {
                return ':';
            }
            case CIRCUMFLEX: {
                return '^';
            }
            case DOLLAR: {
                return '$';
            }
            case EURO_SIGN: {
                return '\u20ac';
            }
            case EXCLAMATION_MARK: {
                return '!';
            }
            case LEFT_PARENTHESIS: {
                return '(';
            }
            case NUMBER_SIGN: {
                return '#';
            }
            case PLUS: {
                return '+';
            }
            case RIGHT_PARENTHESIS: {
                return ')';
            }
            case UNDERSCORE: {
                return '_';
            }
        }
        return '\u0000';
    }
}

