/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ButtonBehavior;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import com.sun.javafx.scene.control.skin.Utils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;

public class ButtonSkin
extends LabeledSkinBase<Button, ButtonBehavior<Button>> {
    Runnable defaultButtonRunnable = new Runnable(){

        @Override
        public void run() {
            ((Button)ButtonSkin.this.getSkinnable()).fire();
        }
    };
    Runnable cancelButtonRunnable = new Runnable(){

        @Override
        public void run() {
            ((Button)ButtonSkin.this.getSkinnable()).fire();
        }
    };

    public ButtonSkin(Button button) {
        super(button, new ButtonBehavior<Button>(button));
        this.registerChangeListener(button.defaultButtonProperty(), "DEFAULT_BUTTON");
        this.registerChangeListener(button.cancelButtonProperty(), "CANCEL_BUTTON");
        this.registerChangeListener(button.focusedProperty(), "FOCUSED");
        if (((Button)this.getSkinnable()).isDefaultButton()) {
            this.setDefaultButton(true);
        }
        if (((Button)this.getSkinnable()).isCancelButton()) {
            this.setCancelButton(true);
        }
        button.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                ContextMenu contextMenu = ((Button)ButtonSkin.this.getSkinnable()).getContextMenu();
                if (contextMenu != null) {
                    if (!contextMenu.isShowing()) {
                        contextMenu.show((Node)((Object)ButtonSkin.this.getSkinnable()), Side.RIGHT, 0.0, 0.0);
                        Utils.addMnemonics(contextMenu, ((Button)ButtonSkin.this.getSkinnable()).getScene());
                    } else {
                        contextMenu.hide();
                        Utils.removeMnemonics(contextMenu, ((Button)ButtonSkin.this.getSkinnable()).getScene());
                    }
                }
            }
        });
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        ContextMenu contextMenu;
        super.handleControlPropertyChanged(string);
        if (string == "DEFAULT_BUTTON") {
            this.setDefaultButton(((Button)this.getSkinnable()).isDefaultButton());
        } else if (string == "CANCEL_BUTTON") {
            this.setCancelButton(((Button)this.getSkinnable()).isCancelButton());
        } else if (string == "FOCUSED" && !((Button)this.getSkinnable()).isFocused() && (contextMenu = ((Button)this.getSkinnable()).getContextMenu()) != null && contextMenu.isShowing()) {
            contextMenu.hide();
            Utils.removeMnemonics(contextMenu, ((Button)this.getSkinnable()).getScene());
        }
    }

    @Override
    protected double computePrefHeight(double d) {
        double d2 = -1.0;
        if (d != -1.0) {
            d2 = Math.max(0.0, d - this.getInsets().getLeft() - this.getInsets().getRight());
        }
        return super.computePrefHeight(d2);
    }

    private void setDefaultButton(boolean bl) {
        KeyCode keyCode = KeyCode.ENTER;
        KeyCodeCombination keyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
        if (!bl) {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(keyCodeCombination);
            if (!this.defaultButtonRunnable.equals(runnable)) {
                ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().remove(keyCodeCombination);
            }
        } else {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(keyCodeCombination);
        }
        ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().put(keyCodeCombination, this.defaultButtonRunnable);
    }

    private void setCancelButton(boolean bl) {
        KeyCode keyCode = KeyCode.ESCAPE;
        KeyCodeCombination keyCodeCombination = new KeyCodeCombination(keyCode, new KeyCombination.Modifier[0]);
        if (!bl) {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(keyCodeCombination);
            if (!this.defaultButtonRunnable.equals(runnable)) {
                ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().remove(keyCodeCombination);
            }
        } else {
            Runnable runnable = (Runnable)((Button)this.getSkinnable()).getParent().getScene().getAccelerators().get(keyCodeCombination);
        }
        ((Button)this.getSkinnable()).getParent().getScene().getAccelerators().put(keyCodeCombination, this.cancelButtonRunnable);
    }
}

