/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.control.Logging;
import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.control.FocusModel;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;

public class TreeCellBehavior
extends CellBehaviorBase<TreeCell<?>> {
    private static final Map<TreeView, Integer> map = new HashMap<TreeView, Integer>();

    public TreeCellBehavior(TreeCell treeCell) {
        super(treeCell);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        TreeCell treeCell = (TreeCell)this.getControl();
        TreeView treeView = treeCell.getTreeView();
        if (treeCell.isEmpty() || !treeCell.contains(mouseEvent.getX(), mouseEvent.getY())) {
            PlatformLogger platformLogger = Logging.getControlsLogger();
            if (!treeCell.isEmpty() || platformLogger.isLoggable(900)) {
                // empty if block
            }
            return;
        }
        int n = treeCell.getIndex();
        boolean bl = treeCell.isSelected();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        if (multipleSelectionModel == null) {
            return;
        }
        FocusModel focusModel = treeView.getFocusModel();
        if (focusModel == null) {
            return;
        }
        Node node = treeCell.getDisclosureNode();
        if (node != null && node.getBoundsInParent().contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (treeCell.getTreeItem() != null) {
                treeCell.getTreeItem().setExpanded(!treeCell.getTreeItem().isExpanded());
            }
            return;
        }
        if (mouseEvent.isShiftDown()) {
            if (!map.containsKey(treeView)) {
                map.put(treeView, focusModel.getFocusedIndex());
            }
        } else {
            map.remove(treeView);
        }
        if (multipleSelectionModel.getSelectionMode() == SelectionMode.SINGLE) {
            this.simpleSelect(mouseEvent);
        } else if (mouseEvent.isControlDown() || mouseEvent.isMetaDown()) {
            if (bl) {
                multipleSelectionModel.clearSelection(n);
            } else {
                multipleSelectionModel.select(n);
            }
        } else if (mouseEvent.isShiftDown()) {
            int n2 = map.containsKey(treeView) ? map.get(treeView).intValue() : focusModel.getFocusedIndex();
            int n3 = Math.min(n2, n);
            int n4 = Math.max(n2, n);
            multipleSelectionModel.clearSelection();
            multipleSelectionModel.selectRange(n3, n4 + 1);
            focusModel.focus(n);
        } else {
            this.simpleSelect(mouseEvent);
        }
    }

    private void simpleSelect(MouseEvent mouseEvent) {
        TreeView treeView = ((TreeCell)this.getControl()).getTreeView();
        int n = ((TreeCell)this.getControl()).getIndex();
        MultipleSelectionModel multipleSelectionModel = treeView.getSelectionModel();
        boolean bl = multipleSelectionModel.isSelected(n);
        treeView.getSelectionModel().clearAndSelect(n);
        if (mouseEvent.getClickCount() == 1 && bl) {
            treeView.edit(((TreeCell)this.getControl()).getTreeItem());
        } else if (mouseEvent.getClickCount() == 1) {
            treeView.edit(null);
        } else if (mouseEvent.getClickCount() == 2 && ((TreeCell)this.getControl()).isEditable()) {
            ((TreeCell)this.getControl()).getTreeItem().setExpanded(!((TreeCell)this.getControl()).getTreeItem().isExpanded());
        }
    }
}

