/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.skin.AccordionSkin;
import com.sun.javafx.scene.control.skin.TitledPaneSkin;
import com.sun.javafx.scene.traversal.Direction;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TitledPaneBehavior
extends BehaviorBase<TitledPane> {
    private TitledPane titledPane;
    private static final String PRESS_ACTION = "Press";
    protected static final List<KeyBinding> TITLEDPANE_BINDINGS = new ArrayList<KeyBinding>();

    public TitledPaneBehavior(TitledPane titledPane) {
        super(titledPane);
        this.titledPane = titledPane;
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return TITLEDPANE_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if (PRESS_ACTION.equals(string)) {
            TitledPane titledPane = (TitledPane)this.getControl();
            if (titledPane.isFocused()) {
                titledPane.setExpanded(!titledPane.isExpanded());
                titledPane.requestFocus();
            }
        } else if ("TraverseNext".equals(string)) {
            TitledPane titledPane = (TitledPane)this.getControl();
            TitledPaneSkin titledPaneSkin = (TitledPaneSkin)titledPane.getSkin();
            titledPaneSkin.getContentRegion().getImpl_traversalEngine().getTopLeftFocusableNode();
            if (!titledPane.isExpanded() || titledPaneSkin.getContentRegion().getImpl_traversalEngine().registeredNodes.isEmpty()) {
                if (((TitledPane)this.getControl()).getParent() != null && ((TitledPane)this.getControl()).getParent() instanceof AccordionSkin) {
                    titledPaneSkin.getContentRegion().getImpl_traversalEngine().trav(((TitledPane)this.getControl()).getParent(), Direction.NEXT);
                } else {
                    super.callAction(string);
                }
            }
        } else if ("TraversePrevious".equals(string)) {
            TitledPane titledPane = (TitledPane)this.getControl();
            TitledPaneSkin titledPaneSkin = (TitledPaneSkin)titledPane.getSkin();
            if (((TitledPane)this.getControl()).getParent() != null && ((TitledPane)this.getControl()).getParent() instanceof AccordionSkin) {
                titledPaneSkin.getContentRegion().getImpl_traversalEngine().trav(((TitledPane)this.getControl()).getParent(), Direction.PREVIOUS);
            } else {
                super.callAction(string);
            }
        } else {
            super.callAction(string);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TitledPane titledPane = (TitledPane)this.getControl();
        titledPane.requestFocus();
    }

    public void expand() {
        this.titledPane.setExpanded(true);
    }

    public void collapse() {
        this.titledPane.setExpanded(false);
    }

    public void toggle() {
        this.titledPane.setExpanded(!this.titledPane.isExpanded());
    }

    static {
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.ENTER, PRESS_ACTION));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.SPACE, PRESS_ACTION));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        TITLEDPANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
    }
}

