/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class ChoiceBoxBehavior
extends BehaviorBase<ChoiceBox> {
    protected static final List<KeyBinding> CHOICE_BUTTON_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String string) {
        if (string.equals("Cancel")) {
            this.cancel();
        } else if (string.equals("Press")) {
            this.keyPressed();
        } else if (string.equals("Release")) {
            this.keyReleased();
        } else if (string.equals("Down")) {
            this.showPopup();
        }
    }

    public ChoiceBoxBehavior(ChoiceBox choiceBox) {
        super(choiceBox);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return CHOICE_BUTTON_BINDINGS;
    }

    public void select(int n) {
        SingleSelectionModel singleSelectionModel = ((ChoiceBox)this.getControl()).getSelectionModel();
        if (singleSelectionModel == null) {
            return;
        }
        ((SelectionModel)singleSelectionModel).select(n);
    }

    public void close() {
        ((ChoiceBox)this.getControl()).hide();
    }

    public void showPopup() {
        ((ChoiceBox)this.getControl()).show();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        ChoiceBox choiceBox = (ChoiceBox)this.getControl();
        super.mousePressed(mouseEvent);
        if (choiceBox.isShowing()) {
            ((ChoiceBox)this.getControl()).hide();
        } else {
            if (choiceBox.isFocusTraversable()) {
                choiceBox.requestFocus();
            }
            choiceBox.show();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        ChoiceBox choiceBox = (ChoiceBox)this.getControl();
        super.mouseReleased(mouseEvent);
        if (!choiceBox.contains(mouseEvent.getX(), mouseEvent.getY())) {
            choiceBox.hide();
        }
    }

    private void keyPressed() {
        ChoiceBox choiceBox = (ChoiceBox)this.getControl();
        if (!choiceBox.isShowing()) {
            choiceBox.show();
        }
    }

    private void keyReleased() {
    }

    public void cancel() {
        ChoiceBox choiceBox = (ChoiceBox)this.getControl();
        choiceBox.hide();
    }

    static {
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, "Press"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, "Release"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_RELEASED, "Cancel"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_RELEASED, "Down"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.CANCEL, KeyEvent.KEY_RELEASED, "Cancel"));
        CHOICE_BUTTON_BINDINGS.addAll(TRAVERSAL_BINDINGS);
    }
}

