/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean usingJNLPAppletLauncher;
    private static Method jnlpLoadLibraryMethod;
    private static boolean verbose;
    private static File libDir;
    private static String libPrefix;
    private static String libSuffix;
    private static String libSuffixAlt;

    public static synchronized void loadLibrary(String string) {
        if (!loaded.contains(string)) {
            NativeLibLoader.loadLibraryInternal(string);
            loaded.add(string);
        }
    }

    private static void loadLibraryInternal(String string) {
        if (usingJNLPAppletLauncher && !string.equals("jawt")) {
            try {
                if (jnlpLoadLibraryMethod == null) {
                    Class<?> clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    jnlpLoadLibraryMethod = clazz.getDeclaredMethod("loadLibrary", String.class);
                }
                jnlpLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
            }
        }
        try {
            NativeLibLoader.loadLibraryFullPath(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            try {
                System.loadLibrary(string);
                if (verbose) {
                    System.err.println("WARNING: " + unsatisfiedLinkError.toString());
                    System.err.println("    using System.loadLibrary(" + string + ") as a fallback");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                throw unsatisfiedLinkError;
            }
        }
    }

    private static void loadLibraryFullPath(String string) {
        block13: {
            try {
                Object object;
                Class<NativeLibLoader> clazz;
                if (libDir == null) {
                    clazz = NativeLibLoader.class;
                    object = "NativeLibLoader.class";
                    String string2 = clazz.getResource((String)object).toString();
                    if (!string2.startsWith("jar:file:") || string2.indexOf("!") == -1) {
                        throw new UnsatisfiedLinkError("Invalid URL for class: " + string2);
                    }
                    String string3 = string2.substring(4, string2.lastIndexOf("!"));
                    int n = Math.max(string3.lastIndexOf("/"), string3.lastIndexOf("\\"));
                    String string4 = string3.substring(0, n) + "/../bin";
                    libDir = new File(new URI(string4).getPath());
                    String string5 = System.getProperty("os.name");
                    if (string5.startsWith("Windows")) {
                        File file;
                        if (System.getProperty("sun.arch.data.model", "").startsWith("64") && (file = new File(libDir, "64bit")).isDirectory()) {
                            libDir = file;
                        }
                        libPrefix = "";
                        libSuffix = ".dll";
                    } else if (string5.startsWith("Mac")) {
                        libPrefix = "lib";
                        libSuffix = ".jnilib";
                        libSuffixAlt = ".dylib";
                    } else if (string5.startsWith("Linux")) {
                        libPrefix = "lib";
                        libSuffix = ".so";
                    }
                }
                object = new File(libDir, libPrefix + string + libSuffix);
                clazz = ((File)object).getCanonicalPath();
                try {
                    System.load((String)((Object)clazz));
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    if (libSuffixAlt != null) {
                        object = new File(libDir, libPrefix + string + libSuffixAlt);
                        clazz = ((File)object).getAbsolutePath();
                        System.load((String)((Object)clazz));
                        break block13;
                    }
                    throw unsatisfiedLinkError;
                }
            }
            catch (Exception exception) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(exception);
            }
        }
    }

    static {
        verbose = false;
        libDir = null;
        libPrefix = "";
        libSuffix = "";
        libSuffixAlt = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String string = System.getProperty("sun.jnlp.applet.launcher");
                usingJNLPAppletLauncher = Boolean.valueOf(string);
                verbose = Boolean.getBoolean("javafx.verbose");
                return null;
            }
        });
    }
}

