/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.KeyPath;
import com.sun.javafx.fxml.expression.VariableExpression;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Expression {
    public abstract Set<KeyPath> getArguments();

    public abstract Object evaluate(Map<String, Object> var1);

    public abstract boolean isDefined(Map<String, Object> var1);

    public static <T> T get(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new IllegalArgumentException();
        }
        return Expression.get(object, keyPath.iterator());
    }

    private static <T> T get(Object object, Iterator<String> iterator) {
        return (T)(iterator.hasNext() ? Expression.get(Expression.get(object, iterator.next()), iterator) : object);
    }

    protected static <T> T get(Object object, String string) {
        T t;
        if (object instanceof List) {
            List list = (List)object;
            t = (T)list.get(Integer.parseInt(string));
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            t = (T)map.get(string);
        } else {
            t = null;
        }
        return t;
    }

    public static byte getByte(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).byteValue();
    }

    public static short getShort(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).shortValue();
    }

    public static int getInt(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).intValue();
    }

    public static long getLong(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).longValue();
    }

    public static float getFloat(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).floatValue();
    }

    public static double getDouble(Object object, KeyPath keyPath) {
        return ((Number)Expression.get(object, keyPath)).doubleValue();
    }

    public static void set(Object object, KeyPath keyPath, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (keyPath == null) {
            throw new IllegalArgumentException();
        }
        Expression.set(object, keyPath.iterator(), object2);
    }

    private static void set(Object object, Iterator<String> iterator, Object object2) {
        String string = iterator.next();
        if (iterator.hasNext()) {
            Expression.set(Expression.get(object, string), iterator, object2);
        } else if (object instanceof List) {
            List list = (List)object;
            list.set(Integer.parseInt(string), object2);
        } else {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            map.put(string, object2);
        }
    }

    public static boolean isDefined(Object object, KeyPath keyPath) {
        if (keyPath == null) {
            throw new IllegalArgumentException();
        }
        return Expression.isDefined(object, keyPath.iterator());
    }

    private static boolean isDefined(Object object, Iterator<String> iterator) {
        boolean bl;
        String string = iterator.next();
        if (iterator.hasNext()) {
            bl = Expression.isDefined(Expression.get(object, string), iterator);
        } else if (object instanceof List) {
            List list = (List)object;
            bl = Integer.parseInt(string) < list.size();
        } else if (object != null) {
            Map map = object instanceof Map ? (Map)object : new BeanAdapter(object);
            bl = map.containsKey(string);
        } else {
            bl = false;
        }
        return bl;
    }

    public static Expression valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        return new VariableExpression(string);
    }
}

