/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.parser;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.Combinator;
import com.sun.javafx.css.CompoundSelector;
import com.sun.javafx.css.Declaration;
import com.sun.javafx.css.FontUnits;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.SimpleSelector;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.Value;
import com.sun.javafx.css.converters.BooleanConverter;
import com.sun.javafx.css.converters.EffectConverter;
import com.sun.javafx.css.converters.EnumConverter;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.css.converters.InsetsConverter;
import com.sun.javafx.css.converters.PaintConverter;
import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.css.converters.StringConverter;
import com.sun.javafx.css.converters.URLConverter;
import com.sun.javafx.css.parser.CSSLexer;
import com.sun.javafx.css.parser.DeriveColorConverter;
import com.sun.javafx.css.parser.LadderConverter;
import com.sun.javafx.css.parser.StopConverter;
import com.sun.javafx.css.parser.Token;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.layout.region.BackgroundImage;
import com.sun.javafx.scene.layout.region.BorderImage;
import com.sun.javafx.scene.layout.region.BorderStyle;
import com.sun.javafx.scene.layout.region.Margins;
import com.sun.javafx.scene.layout.region.Repeat;
import com.sun.javafx.scene.layout.region.StrokeBorder;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.Insets;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;

public final class CSSParser {
    static boolean EXIT_ON_ERROR = false;
    private Stylesheet stylesheet = null;
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private final Map<String, String> properties = new HashMap<String, String>();
    private static final Value<Size, Size> ZERO_PERCENT;
    private static final Value<Size, Size> FIFTY_PERCENT;
    private static final Value<Size, Size> ONE_HUNDRED_PERCENT;
    private static final Value<Value<?, Size>[], Double[]> DASHED;
    private static final Value<Value<?, Size>[], Double[]> DOTTED;
    private static final Value<Value<?, Size>[], Double[]> SOLID;
    private static final Value<Value<?, Size>[], Double[]> NONE;
    Token currentToken = null;

    public static CSSParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private CSSParser() {
    }

    public Stylesheet parse(String string) throws IOException {
        return this.parse(ClassLoader.getSystemResource(""), string);
    }

    public Stylesheet parse(String string, String string2) throws IOException {
        return this.parse(new URL(string), string2);
    }

    private Stylesheet parse(URL uRL, String string) throws IOException {
        CharArrayReader charArrayReader;
        if (string != null && !string.trim().isEmpty()) {
            charArrayReader = new CharArrayReader(string.toCharArray());
            this.stylesheet = new Stylesheet(uRL);
            this.parse(charArrayReader);
        }
        charArrayReader = this.stylesheet == null || this.stylesheet.getRules().isEmpty() ? null : this.stylesheet;
        this.stylesheet = null;
        return charArrayReader;
    }

    public Stylesheet parse(URL uRL) throws IOException {
        BufferedReader bufferedReader;
        if (uRL != null) {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            this.stylesheet = new Stylesheet(uRL);
            this.parse(bufferedReader);
        }
        bufferedReader = this.stylesheet == null || this.stylesheet.getRules().isEmpty() ? null : this.stylesheet;
        this.stylesheet = null;
        return bufferedReader;
    }

    private void parse(Reader reader) {
        CSSLexer cSSLexer = CSSLexer.getInstance();
        cSSLexer.setReader(reader);
        this.parse(cSSLexer);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Stylesheet parseStyle(String string) {
        CharArrayReader charArrayReader;
        if (string != null && !string.trim().isEmpty()) {
            charArrayReader = new CharArrayReader(string.toCharArray());
            CSSLexer cSSLexer = CSSLexer.getInstance();
            cSSLexer.setReader(charArrayReader);
            this.currentToken = this.nextToken(cSSLexer);
            this.stylesheet = new Stylesheet();
            List<Declaration> list = this.declarations(cSSLexer);
            if (list != null && !list.isEmpty()) {
                Selector selector = Selector.getUniversalSelector();
                Rule rule = new Rule(Collections.singletonList(selector), list);
                this.stylesheet.addRule(rule);
            }
            try {
                ((Reader)charArrayReader).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        charArrayReader = this.stylesheet == null || this.stylesheet.getRules().isEmpty() ? null : this.stylesheet;
        this.stylesheet = null;
        return charArrayReader;
    }

    public Value parseExpr(String string, String string2) {
        Value value;
        block3: {
            value = null;
            try {
                char[] cArray = new char[string2.length() + 1];
                System.arraycopy(string2.toCharArray(), 0, cArray, 0, string2.length());
                cArray[cArray.length - 1] = 59;
                CharArrayReader charArrayReader = new CharArrayReader(cArray);
                CSSLexer cSSLexer = CSSLexer.getInstance();
                cSSLexer.setReader(charArrayReader);
                this.currentToken = this.nextToken(cSSLexer);
                Term term = this.expr(cSSLexer);
                value = this.valueFor(string, term);
                ((Reader)charArrayReader).close();
            }
            catch (IOException iOException) {
            }
            catch (ParseException parseException) {
                if (!LOGGER.isLoggable(900)) break block3;
                LOGGER.warning(parseException.toString() + " \"" + string + ": " + string2 + "\"");
            }
        }
        return value;
    }

    private void error(Term term, String string) throws ParseException {
        Token token = term.token;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.stylesheet != null && this.stylesheet.getUrl() != null) {
            stringBuilder.append(this.stylesheet.getUrl().toExternalForm());
        }
        stringBuilder.append(token.toString());
        if (string != null && !string.isEmpty()) {
            stringBuilder.append(" ").append(string);
        }
        String string2 = stringBuilder.toString();
        throw new ParseException(string2);
    }

    private String formatDeprecatedMessage(Term term, String string) {
        StringBuilder stringBuilder = new StringBuilder("Using deprecated syntax for ");
        stringBuilder.append(string);
        if (this.stylesheet != null) {
            stringBuilder.append(" at ");
            if (this.stylesheet.getUrl() != null) {
                stringBuilder.append(this.stylesheet.getUrl().toExternalForm());
            }
            stringBuilder.append("[").append(term.token.getLine()).append(',').append(term.token.getOffset()).append("]");
        }
        stringBuilder.append(". Refer to the CSS Reference Guide.");
        return stringBuilder.toString();
    }

    private Value<Color, Color> colorValueOfString(String string) {
        if (string.startsWith("#") || string.startsWith("0x")) {
            double d = 1.0;
            String string2 = string;
            int n = string.startsWith("#") ? 1 : 2;
            int n2 = string2.length();
            if (n2 - n == 4) {
                d = (float)Integer.parseInt(string2.substring(n2 - 1), 16) / 15.0f;
                string2 = string2.substring(0, n2 - 1);
            } else if (n2 - n == 8) {
                d = (float)Integer.parseInt(string2.substring(n2 - 2), 16) / 255.0f;
                string2 = string2.substring(0, n2 - 2);
            }
            return new Value<Color, Color>(Color.web(string2, d), null);
        }
        try {
            return new Value<Color, Color>(Color.web(string), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private String stripQuotes(String string) {
        return Utils.stripQuotes(string);
    }

    private double clamp(double d, double d2, double d3) {
        if (d2 < d) {
            return d;
        }
        if (d3 < d2) {
            return d3;
        }
        return d2;
    }

    private boolean isSize(Token token) {
        int n = token.getType();
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return token.getType() == 11;
    }

    private Size size(Token token) throws ParseException {
        SizeUnits sizeUnits = SizeUnits.PX;
        int n = 2;
        String string = token.getText().trim();
        int n2 = string.length();
        int n3 = token.getType();
        switch (n3) {
            case 13: {
                sizeUnits = SizeUnits.PX;
                n = 0;
                break;
            }
            case 22: {
                sizeUnits = SizeUnits.PERCENT;
                n = 1;
                break;
            }
            case 15: {
                sizeUnits = SizeUnits.EM;
                break;
            }
            case 16: {
                sizeUnits = SizeUnits.EX;
                break;
            }
            case 21: {
                sizeUnits = SizeUnits.PX;
                break;
            }
            case 14: {
                sizeUnits = SizeUnits.CM;
                break;
            }
            case 18: {
                sizeUnits = SizeUnits.MM;
                break;
            }
            case 17: {
                sizeUnits = SizeUnits.IN;
                break;
            }
            case 20: {
                sizeUnits = SizeUnits.PT;
                break;
            }
            case 19: {
                sizeUnits = SizeUnits.PC;
                break;
            }
            case 23: {
                sizeUnits = SizeUnits.DEG;
                n = 3;
                break;
            }
            case 24: {
                sizeUnits = SizeUnits.GRAD;
                n = 4;
                break;
            }
            case 25: {
                sizeUnits = SizeUnits.RAD;
                n = 3;
                break;
            }
            case 26: {
                sizeUnits = SizeUnits.TURN;
                n = 5;
                break;
            }
            default: {
                if (LOGGER.isLoggable(300)) {
                    LOGGER.finest("Expected '<number>'");
                }
                ParseException parseException = new ParseException("Expected '<number>'", token);
                throw parseException;
            }
        }
        return new Size(Double.parseDouble(string.substring(0, n2 - n)), sizeUnits);
    }

    private int numberOfTerms(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term;
        do {
            ++n;
        } while ((term2 = term2.nextInSeries) != null);
        return n;
    }

    private int numberOfLayers(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term;
        do {
            ++n;
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
        } while ((term2 = term2.nextLayer) != null);
        return n;
    }

    private int numberOfArgs(Term term) {
        if (term == null) {
            return 0;
        }
        int n = 0;
        Term term2 = term.firstArg;
        while (term2 != null) {
            ++n;
            term2 = term2.nextArg;
        }
        return n;
    }

    private Term nextLayer(Term term) {
        if (term == null) {
            return null;
        }
        Term term2 = term;
        while (term2.nextInSeries != null) {
            term2 = term2.nextInSeries;
        }
        return term2.nextLayer;
    }

    Value valueFor(String string, Term term) throws ParseException {
        String string2 = string.toLowerCase();
        this.properties.put(string2, string2);
        if (term.token == null) {
            this.error(term, "Expected value for property '" + string2 + "'");
        }
        if (term.token.getType() == 11) {
            if ("inherit".equalsIgnoreCase(term.token.getText())) {
                return new Value("inherit", null);
            }
            if ("null".equalsIgnoreCase(term.token.getText())) {
                return new Value("null", null);
            }
        }
        if ("-fx-background-color".equals(string)) {
            return this.parsePaintLayers(term);
        }
        if ("-fx-background-image".equals(string2)) {
            return this.parseURILayers(term);
        }
        if ("-fx-background-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-background-position".equals(string2)) {
            return this.parseBackgroundPositionLayers(term);
        }
        if ("-fx-background-radius".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-background-repeat".equals(string2)) {
            return this.parseBackgroundRepeatStyleLayers(term);
        }
        if ("-fx-background-size".equals(string2)) {
            return this.parseBackgroundSizeLayers(term);
        }
        if ("-fx-border-color".equals(string2)) {
            return this.parseBorderPaintLayers(term);
        }
        if ("-fx-border-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-border-radius".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-border-style".equals(string2)) {
            return this.parseBorderStyleLayers(term);
        }
        if ("-fx-border-width".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-border-image-insets".equals(string2)) {
            return this.parseInsetsLayers(term);
        }
        if ("-fx-border-image-repeat".equals(string2)) {
            return this.parseBorderImageRepeatStyleLayers(term);
        }
        if ("-fx-border-image-slice".equals(string2)) {
            return this.parseBorderImageSliceLayers(term);
        }
        if ("-fx-border-image-source".equals(string2)) {
            return this.parseURILayers(term);
        }
        if ("-fx-border-image-width".equals(string2)) {
            return this.parseMarginsLayers(term);
        }
        if ("-fx-padding".equals(string2)) {
            Value<?, Size>[] valueArray = this.parseSizeSeries(term);
            return new Value<Value<?, Size>[], Insets>(valueArray, InsetsConverter.getInstance());
        }
        if ("-fx-label-padding".equals(string2)) {
            Value<?, Size>[] valueArray = this.parseSizeSeries(term);
            return new Value<Value<?, Size>[], Insets>(valueArray, InsetsConverter.getInstance());
        }
        if (string2.endsWith("font-family")) {
            return this.parseFontFamily(term);
        }
        if (string2.endsWith("font-size")) {
            Value<Value<?, Size>, Double> value = this.parseFontSize(term);
            if (value == null) {
                this.error(term, "Expected '<font-size>'");
            }
            return value;
        }
        if (string2.endsWith("font-style")) {
            Value<FontUnits.Style, FontPosture> value = this.parseFontStyle(term);
            if (value == null) {
                this.error(term, "Expected '<font-style>'");
            }
            return value;
        }
        if (string2.endsWith("font-weight")) {
            Value<FontUnits.Weight, FontWeight> value = this.parseFontWeight(term);
            if (value == null) {
                this.error(term, "Expected '<font-style>'");
            }
            return value;
        }
        if (string2.endsWith("font")) {
            return this.parseFont(term);
        }
        if ("-fx-stroke-dash-array".equals(string2)) {
            Term term2 = term;
            int n = this.numberOfTerms(term2);
            Value[] valueArray = new Value[n];
            int n2 = 0;
            while (term2 != null) {
                valueArray[n2++] = this.parseSize(term2);
                term2 = term2.nextInSeries;
            }
            return new Value<Value<?, Size>[], Double[]>(valueArray, SizeConverter.SequenceConverter.getInstance());
        }
        if ("-fx-stroke-line-join".equals(string2)) {
            Value[] valueArray = this.parseStrokeLineJoin(term);
            if (valueArray == null) {
                this.error(term, "Expected 'miter', 'bevel' or 'round'");
            }
            return valueArray[0];
        }
        if ("-fx-stroke-line-cap".equals(string2)) {
            Value<String, StrokeLineCap> value = this.parseStrokeLineCap(term);
            if (value == null) {
                this.error(term, "Expected 'square', 'butt' or 'round'");
            }
            return value;
        }
        if ("-fx-stroke-type".equals(string2)) {
            Value<String, StrokeType> value = this.parseStrokeType(term);
            if (value == null) {
                this.error(term, "Expected 'centered', 'inside' or 'outside'");
            }
            return value;
        }
        return this.parse(term);
    }

    private Value parse(Term term) throws ParseException {
        if (term.token == null) {
            this.error(term, "Parse error");
        }
        Token token = term.token;
        Value<Object, Object> value = null;
        int n = token.getType();
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                Value value2 = new Value(this.size(token), null);
                value = new Value(value2, SizeConverter.getInstance());
                break;
            }
            case 10: 
            case 11: {
                boolean bl;
                boolean bl2 = n == 11;
                String string = this.stripQuotes(token.getText());
                String string2 = string.toLowerCase();
                if ("ladder".equals(string2)) {
                    value = this.ladder(term);
                    break;
                }
                if ("linear".equals(string2)) {
                    value = this.linearGradient(term);
                    break;
                }
                if ("radial".equals(string2)) {
                    value = this.radialGradient(term);
                    break;
                }
                if ("true".equals(string2)) {
                    value = new Value<String, Boolean>("true", BooleanConverter.getInstance());
                    break;
                }
                if ("false".equals(string2)) {
                    value = new Value<String, Boolean>("false", BooleanConverter.getInstance());
                    break;
                }
                boolean bl3 = bl = bl2 && this.properties.containsKey(string);
                if (!bl && (value = this.colorValueOfString(string)) != null) break;
                value = new Value(string, null, bl2 || bl);
                break;
            }
            case 37: {
                String string = token.getText();
                try {
                    value = new Value(Color.web(string), null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.error(term, illegalArgumentException.getMessage());
                }
                break;
            }
            case 12: {
                return this.parseFunction(term);
            }
            default: {
                String string = "Unknown token type: '" + n + "'";
                this.error(term, string);
            }
        }
        return value;
    }

    private Value<?, Size> parseSize(Term term) throws ParseException {
        if (term.token == null || !this.isSize(term.token)) {
            this.error(term, "Expected '<size>'");
        }
        Value value = null;
        if (term.token.getType() != 11) {
            Size size = this.size(term.token);
            value = new Value(size, null);
        } else {
            String string = term.token.getText();
            value = new Value(string, null, true);
        }
        return value;
    }

    private Value<?, Color> parseColor(Term term) throws ParseException {
        Value value = null;
        if (term.token != null && (term.token.getType() == 11 || term.token.getType() == 37 || term.token.getType() == 12)) {
            value = this.parse(term);
        } else {
            this.error(term, "Expected '<color>'");
        }
        return value;
    }

    private Value rgb(Term term) throws ParseException {
        int n;
        Token token;
        Token token2;
        Token token3;
        Token token4;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"rgb".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'rgb' or 'rgba'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token4 = term2.token) == null || token4.getType() != 13 && token4.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token3 = term2.token) == null || token3.getType() != 13 && token3.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>' or '<percentage>'");
        }
        if ((token2 = term2.token) == null || token2.getType() != 13 && token2.getType() != 22) {
            this.error(term2, "Expected '<number>' or '<percentage>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 != null) {
            token = term2.token;
            if (token == null || token.getType() != 13) {
                this.error(term2, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        if ((n = token4.getType()) != token3.getType() || n != token2.getType() || n != 13 && n != 22) {
            this.error(term, "Argument type mistmatch");
        }
        String string3 = token4.getText();
        String string4 = token3.getText();
        String string5 = token2.getText();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n == 13) {
            d = this.clamp(0.0, Double.parseDouble(string3) / 255.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble(string4) / 255.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble(string5) / 255.0, 1.0);
        } else {
            d = this.clamp(0.0, Double.parseDouble(string3.substring(0, string3.length() - 1)) / 100.0, 1.0);
            d2 = this.clamp(0.0, Double.parseDouble(string4.substring(0, string4.length() - 1)) / 100.0, 1.0);
            d3 = this.clamp(0.0, Double.parseDouble(string5.substring(0, string5.length() - 1)) / 100.0, 1.0);
        }
        String string6 = token != null ? token.getText() : null;
        double d4 = string6 != null ? this.clamp(0.0, Double.parseDouble(string6), 1.0) : 1.0;
        return new Value(Color.color(d, d2, d3, d4), null);
    }

    private Value hsb(Term term) throws ParseException {
        Token token;
        Token token2;
        Token token3;
        Token token4;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"hsb".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'hsb' or 'hsba'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        if ((token4 = term2.token) == null || token4.getType() != 13) {
            this.error(term2, "Expected '<number>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<percent>'");
        }
        if ((token3 = term2.token) == null || token3.getType() != 22) {
            this.error(term2, "Expected '<percent>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term, "Expected '<percent>'");
        }
        if ((token2 = term2.token) == null || token2.getType() != 22) {
            this.error(term2, "Expected '<percent>'");
        }
        term = term2;
        term2 = term2.nextArg;
        if (term2 != null) {
            token = term2.token;
            if (token == null || token.getType() != 13) {
                this.error(term2, "Expected '<number>'");
            }
        } else {
            token = null;
        }
        String string3 = token4.getText();
        String string4 = token3.getText();
        String string5 = token2.getText();
        double d = Double.parseDouble(string3);
        double d2 = this.clamp(0.0, Double.parseDouble(string4.substring(0, string4.length() - 1)), 1.0);
        double d3 = this.clamp(0.0, Double.parseDouble(string5.substring(0, string5.length() - 1)), 1.0);
        String string6 = token != null ? token.getText() : null;
        double d4 = string6 != null ? this.clamp(0.0, Double.parseDouble(string6), 1.0) : 1.0;
        return new Value(Color.hsb(Double.valueOf(d).intValue(), d2, d3, d4), null);
    }

    private Value<Value[], Color> derive(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"derive".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'derive'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        Value<?, Color> value = this.parseColor(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<percent'");
        }
        Value<?, Size> value2 = this.parseSize(term2);
        Value[] valueArray = new Value[]{value, value2};
        return new Value<Value[], Color>(valueArray, DeriveColorConverter.getInstance());
    }

    private Value<Value[], Color> ladder(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"ladder".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'ladder'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "ladder"));
        }
        Term term2 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        Value value = this.parse(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <color>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        Value[] valueArray = new Value[n + 1];
        valueArray[0] = value;
        int n2 = 1;
        do {
            Value<Value[], Stop> value2;
            if ((value2 = this.stop(term2)) != null) {
                valueArray[n2++] = value2;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        if (term2 != null) {
            term.nextInSeries = term2;
        } else {
            term.nextInSeries = null;
            term.nextLayer = term3.nextLayer;
        }
        return new Value<Value[], Color>(valueArray, LadderConverter.getInstance());
    }

    private Value<Value[], Color> parseLadder(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"ladder".regionMatches(true, 0, string, 0, 6)) {
            this.error(term, "Expected 'ladder'");
        }
        Term term2 = term;
        term2 = term2.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<color>'");
        }
        Value value = this.parse(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color-stop>[, <color-stop>]+'");
        }
        Value<Value[], Stop>[] valueArray = this.parseColorStops(term2);
        Value[] valueArray2 = new Value[valueArray.length + 1];
        valueArray2[0] = value;
        System.arraycopy(valueArray, 0, valueArray2, 1, valueArray.length);
        return new Value<Value[], Color>(valueArray2, LadderConverter.getInstance());
    }

    private Value<Value[], Stop> stop(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"(".equals(string)) {
            this.error(term, "Expected '('");
        }
        Term term2 = null;
        term2 = term.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        Value<?, Size> value = this.parseSize(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        Value<?, Color> value2 = this.parseColor(term2);
        Value[] valueArray = new Value[]{value, value2};
        return new Value<Value[], Stop>(valueArray, StopConverter.getInstance());
    }

    private Value<Value[], Stop>[] parseColorStops(Term term) throws ParseException {
        int n = 1;
        Term term2 = term;
        while (term2 != null) {
            if (term2.nextArg != null) {
                ++n;
                term2 = term2.nextArg;
                continue;
            }
            if (term2.nextInSeries == null) break;
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            this.error(term, "Expected '<color-stop>'");
        }
        Value[] valueArray = new Value[n];
        Object[] objectArray = new Size[n];
        Arrays.fill(objectArray, null);
        Term term3 = term;
        Term term4 = term;
        Object var8_8 = null;
        for (int i = 0; i < n; ++i) {
            valueArray[i] = this.parseColor(term3);
            term4 = term3;
            Term term5 = term3.nextInSeries;
            if (term5 != null) {
                if (this.isSize(term5.token)) {
                    objectArray[i] = this.size(term5.token);
                    if (var8_8 != null && var8_8 != ((Size)objectArray[i]).getUnits()) {
                        this.error(term5, "Parser unable to handle mixed '<percent>' and '<length>'");
                    }
                } else {
                    this.error(term4, "Expected '<percent>' or '<length>'");
                }
                term4 = term5;
                term3 = term5.nextArg;
                continue;
            }
            term4 = term3;
            term3 = term3.nextArg;
        }
        if (objectArray[0] == null) {
            objectArray[0] = new Size(0.0, SizeUnits.PERCENT);
        }
        if (objectArray[n - 1] == null) {
            objectArray[n - 1] = new Size(100.0, SizeUnits.PERCENT);
        }
        Object object = null;
        for (int i = 1; i < n; ++i) {
            Object object2;
            Object object3 = objectArray[i - 1];
            if (object3 == null) continue;
            if (object == null || ((Size)object).getValue() < ((Size)object3).getValue()) {
                object = object3;
            }
            if ((object2 = objectArray[i]) == null || !(((Size)object2).getValue() < ((Size)object).getValue())) continue;
            objectArray[i] = object;
        }
        Object object4 = null;
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            Object object5 = objectArray[i];
            if (object5 == null) {
                if (n2 != -1) continue;
                n2 = i;
                continue;
            }
            if (n2 > -1) {
                int n3 = i - n2;
                double d = ((Size)object4).getValue();
                double d2 = (((Size)object5).getValue() - d) / (double)(n3 + 1);
                while (n2 < i) {
                    objectArray[n2++] = new Size(d += d2, ((Size)object5).getUnits());
                }
                n2 = -1;
                object4 = object5;
                continue;
            }
            object4 = object5;
        }
        Value[] valueArray2 = new Value[n];
        for (int i = 0; i < n; ++i) {
            valueArray2[i] = new Value<Value[], Stop>(new Value[]{new Value(objectArray[i], null), valueArray[i]}, StopConverter.getInstance());
        }
        return valueArray2;
    }

    private Value[] point(Term term) throws ParseException {
        String string;
        if (term.token == null || term.token.getType() != 34) {
            this.error(term, "Expected '(<number>, <number>)'");
        }
        if ((string = term.token.getText()) == null || !"(".equalsIgnoreCase(string)) {
            this.error(term, "Expected '('");
        }
        Term term2 = null;
        term2 = term.firstArg;
        if (term2 == null) {
            this.error(term, "Expected '<number>'");
        }
        Value<?, Size> value = this.parseSize(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value2 = this.parseSize(term2);
        return new Value[]{value, value2};
    }

    private Value parseFunction(Term term) throws ParseException {
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null) {
            this.error(term, "Expected function name");
        } else {
            if ("rgb".regionMatches(true, 0, string, 0, 3)) {
                return this.rgb(term);
            }
            if ("hsb".regionMatches(true, 0, string, 0, 3)) {
                return this.hsb(term);
            }
            if ("derive".regionMatches(true, 0, string, 0, 6)) {
                return this.derive(term);
            }
            if ("innershadow".regionMatches(true, 0, string, 0, 11)) {
                return this.innershadow(term);
            }
            if ("dropshadow".regionMatches(true, 0, string, 0, 10)) {
                return this.dropshadow(term);
            }
            if ("linear-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseLinearGradient(term);
            }
            if ("radial-gradient".regionMatches(true, 0, string, 0, 15)) {
                return this.parseRadialGradient(term);
            }
            if ("ladder".regionMatches(true, 0, string, 0, 6)) {
                return this.parseLadder(term);
            }
            if ("url".regionMatches(true, 0, string, 0, 3)) {
                return this.parseURI(term);
            }
            this.error(term, "Unexpected function '" + string + "'");
        }
        return null;
    }

    private Value<BlurType, BlurType> blurType(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        String string = term.token.getText().toLowerCase();
        BlurType blurType = BlurType.THREE_PASS_BOX;
        if ("gaussian".equals(string)) {
            blurType = BlurType.GAUSSIAN;
        } else if ("one-pass-box".equals(string)) {
            blurType = BlurType.ONE_PASS_BOX;
        } else if ("two-pass-box".equals(string)) {
            blurType = BlurType.TWO_PASS_BOX;
        } else if ("three-pass-box".equals(string)) {
            blurType = BlurType.THREE_PASS_BOX;
        } else {
            this.error(term, "Expected 'gaussian', 'one-pass-box', 'two-pass-box', or 'three-pass-box'");
        }
        return new Value<BlurType, BlurType>(blurType, null);
    }

    private Value innershadow(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"innershadow".regionMatches(true, 0, string, 0, 11)) {
            this.error(term, "Expected 'innershadow'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected '<blur-type>'");
        }
        Value<BlurType, BlurType> value = this.blurType(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        Value<?, Color> value2 = this.parseColor(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value3 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value4 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value5 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value6 = this.parseSize(term2);
        Value[] valueArray = new Value[]{value, value2, value3, value4, value5, value6};
        return new Value<Value[], Effect>(valueArray, EffectConverter.InnerShadowConverter.getInstance());
    }

    private Value dropshadow(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"dropshadow".regionMatches(true, 0, string, 0, 10)) {
            this.error(term, "Expected 'dropshadow'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected '<blur-type>'");
        }
        Value<BlurType, BlurType> value = this.blurType(term2);
        Term term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<color>'");
        }
        Value<?, Color> value2 = this.parseColor(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value3 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value4 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value5 = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextArg;
        if (term2 == null) {
            this.error(term3, "Expected '<number>'");
        }
        Value<?, Size> value6 = this.parseSize(term2);
        Value[] valueArray = new Value[]{value, value2, value3, value4, value5, value6};
        return new Value<Value[], Effect>(valueArray, EffectConverter.DropShadowConverter.getInstance());
    }

    private Value<CycleMethod, CycleMethod> cycleMethod(Term term) {
        CycleMethod cycleMethod = null;
        if (term != null && term.token.getType() == 11) {
            String string = term.token.getText().toLowerCase();
            if ("repeat".equals(string)) {
                cycleMethod = CycleMethod.REPEAT;
            } else if ("reflect".equals(string)) {
                cycleMethod = CycleMethod.REFLECT;
            } else if ("no-cycle".equals(string)) {
                cycleMethod = CycleMethod.NO_CYCLE;
            }
        }
        if (cycleMethod != null) {
            return new Value(cycleMethod, null);
        }
        return null;
    }

    private Value<Value[], Paint> linearGradient(Term term) throws ParseException {
        Value<Object, Object> value;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"linear".equalsIgnoreCase(string)) {
            this.error(term, "Expected 'linear'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "linear gradient"));
        }
        Term term2 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected '(<number>, <number>)'");
        }
        Value[] valueArray = this.point(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'to'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"to".equalsIgnoreCase(term2.token.getText())) {
            this.error(term, "Expected 'to'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        Value[] valueArray2 = this.point(term2);
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops'");
        }
        if (term2.token == null || term2.token.getType() != 11 || !"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        Value[] valueArray3 = new Value[n];
        int n2 = 0;
        do {
            if ((value = this.stop(term2)) != null) {
                valueArray3[n2++] = value;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        value = this.cycleMethod(term2);
        if (value == null) {
            value = new Value(CycleMethod.NO_CYCLE, null);
            if (term2 != null) {
                term.nextInSeries = term2;
            } else {
                term.nextInSeries = null;
                term.nextLayer = term3.nextLayer;
            }
        } else {
            term.nextInSeries = term2.nextInSeries;
            term.nextLayer = term2.nextLayer;
        }
        Value[] valueArray4 = new Value[5 + valueArray3.length];
        int n3 = 0;
        valueArray4[n3++] = valueArray != null ? valueArray[0] : null;
        valueArray4[n3++] = valueArray != null ? valueArray[1] : null;
        valueArray4[n3++] = valueArray2 != null ? valueArray2[0] : null;
        valueArray4[n3++] = valueArray2 != null ? valueArray2[1] : null;
        valueArray4[n3++] = value;
        for (int i = 0; i < valueArray3.length; ++i) {
            valueArray4[n3++] = valueArray3[i];
        }
        return new Value<Value[], Paint>(valueArray4, PaintConverter.LinearGradientConverter.getInstance());
    }

    private Value parseLinearGradient(Term term) throws ParseException {
        int n;
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"linear-gradient".regionMatches(true, 0, string, 0, 15)) {
            this.error(term, "Expected 'linear-gradient'");
        }
        if ((term2 = term.firstArg) == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term, "Expected 'from <point> to <point>' or 'to <side-or-corner>' or '<cycle-method>' or '<color-stop>'");
        }
        Term term3 = term2;
        Value[] valueArray = null;
        Value[] valueArray2 = null;
        if ("from".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            Value<?, Size> value = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            Value<?, Size> value2 = this.parseSize(term2);
            valueArray = new Value[]{value, value2};
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected 'to'");
            }
            if (term2.token == null || term2.token.getType() != 11 || !"to".equalsIgnoreCase(term2.token.getText())) {
                this.error(term3, "Expected 'to'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            value = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            value2 = this.parseSize(term2);
            valueArray2 = new Value[]{value, value2};
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("to".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null | term2.token.getType() != 11 || term2.token.getText().isEmpty()) {
                this.error(term3, "Expected '<side-or-corner>'");
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            n = 0;
            String string3 = term2.token.getText().toLowerCase();
            if ("top".equals(string3)) {
                n3 = 100;
                n = 0;
            } else if ("bottom".equals(string3)) {
                n3 = 0;
                n = 100;
            } else if ("right".equals(string3)) {
                n2 = 0;
                n4 = 100;
            } else if ("left".equals(string3)) {
                n2 = 100;
                n4 = 0;
            } else {
                this.error(term2, "Invalid '<side-or-corner>'");
            }
            term3 = term2;
            if (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
                if (term2.token != null && term2.token.getType() == 11 && !term2.token.getText().isEmpty()) {
                    String string4 = term2.token.getText().toLowerCase();
                    if ("right".equals(string4) && n2 == 0 && n4 == 0) {
                        n2 = 0;
                        n4 = 100;
                    } else if ("left".equals(string4) && n2 == 0 && n4 == 0) {
                        n2 = 100;
                        n4 = 0;
                    } else if ("top".equals(string4) && n3 == 0 && n == 0) {
                        n3 = 100;
                        n = 0;
                    } else if ("bottom".equals(string4) && n3 == 0 && n == 0) {
                        n3 = 0;
                        n = 100;
                    } else {
                        this.error(term2, "Invalid '<side-or-corner>'");
                    }
                } else {
                    this.error(term3, "Expected '<side-or-corner>'");
                }
            }
            valueArray = new Value[]{new Value(new Size(n2, SizeUnits.PERCENT), null), new Value(new Size(n3, SizeUnits.PERCENT), null)};
            valueArray2 = new Value[]{new Value(new Size(n4, SizeUnits.PERCENT), null), new Value(new Size(n, SizeUnits.PERCENT), null)};
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (valueArray == null && valueArray2 == null) {
            valueArray = new Value[]{new Value(new Size(0.0, SizeUnits.PERCENT), null), new Value(new Size(0.0, SizeUnits.PERCENT), null)};
            valueArray2 = new Value[]{new Value(new Size(0.0, SizeUnits.PERCENT), null), new Value(new Size(100.0, SizeUnits.PERCENT), null)};
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<cycle-method>' or '<color-stop>'");
        }
        CycleMethod cycleMethod = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(term2.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("repeat".equalsIgnoreCase(term2.token.getText())) {
            cycleMethod = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<color-stop>'");
        }
        Value<Value[], Stop>[] valueArray3 = this.parseColorStops(term2);
        Value[] valueArray4 = new Value[5 + valueArray3.length];
        n = 0;
        valueArray4[n++] = valueArray != null ? valueArray[0] : null;
        valueArray4[n++] = valueArray != null ? valueArray[1] : null;
        valueArray4[n++] = valueArray2 != null ? valueArray2[0] : null;
        valueArray4[n++] = valueArray2 != null ? valueArray2[1] : null;
        valueArray4[n++] = new Value(cycleMethod, null);
        for (int i = 0; i < valueArray3.length; ++i) {
            valueArray4[n++] = valueArray3[i];
        }
        return new Value<Value[], Paint>(valueArray4, PaintConverter.LinearGradientConverter.getInstance());
    }

    private Value<Value[], Paint> radialGradient(Term term) throws ParseException {
        Value<Object, Object> value;
        Object object;
        Value[] valueArray;
        Object object2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (string == null || !"radial".equalsIgnoreCase(string)) {
            this.error(term, "Expected 'radial'");
        }
        if (LOGGER.isLoggable(900)) {
            LOGGER.warning(this.formatDeprecatedMessage(term, "radial gradient"));
        }
        Term term2 = term;
        Term term3 = term;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        if (term2.token == null) {
            this.error(term2, "Expected 'focus-angle <number>', 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
        }
        Value<?, Size> value2 = null;
        if (term2.token.getType() == 11 && "focus-angle".equals(object2 = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<number>'");
            }
            if (term2.token == null) {
                this.error(term3, "Expected '<number>'");
            }
            value2 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected 'focus-distance <number>', 'center (<number>,<number>)' or '<size>'");
            }
        }
        object2 = null;
        if (term2.token.getType() == 11 && "focus-distance".equals(valueArray = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<number>'");
            }
            if (term2.token == null) {
                this.error(term3, "Expected '<number>'");
            }
            object2 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected  'center (<number>,<number>)' or '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected  'center (<number>,<number>)' or '<size>'");
            }
        }
        valueArray = null;
        if (term2.token.getType() == 11 && "center".equals(object = term2.token.getText().toLowerCase())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '(<number>,<number>)'");
            }
            if (term2.token == null || term2.token.getType() != 34) {
                this.error(term2, "Expected '(<number>,<number>)'");
            }
            valueArray = this.point(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<size>'");
            }
            if (term2.token == null) {
                this.error(term2, "Expected '<size>'");
            }
        }
        object = this.parseSize(term2);
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected 'stops' keyword");
        }
        if (term2.token == null || term2.token.getType() != 11) {
            this.error(term2, "Expected 'stops' keyword");
        }
        if (!"stops".equalsIgnoreCase(term2.token.getText())) {
            this.error(term2, "Expected 'stops'");
        }
        term3 = term2;
        term2 = term2.nextInSeries;
        if (term2 == null) {
            this.error(term3, "Expected '(<number>, <number>)'");
        }
        int n = 0;
        Term term4 = term2;
        do {
            ++n;
        } while ((term4 = term4.nextInSeries) != null && term4.token != null && term4.token.getType() == 34);
        Value[] valueArray2 = new Value[n];
        int n2 = 0;
        do {
            if ((value = this.stop(term2)) != null) {
                valueArray2[n2++] = value;
            }
            term3 = term2;
        } while ((term2 = term2.nextInSeries) != null && term2.token.getType() == 34);
        value = this.cycleMethod(term2);
        if (value == null) {
            value = new Value(CycleMethod.NO_CYCLE, null);
            if (term2 != null) {
                term.nextInSeries = term2;
            } else {
                term.nextInSeries = null;
                term.nextLayer = term3.nextLayer;
            }
        } else {
            term.nextInSeries = term2.nextInSeries;
            term.nextLayer = term2.nextLayer;
        }
        Value[] valueArray3 = new Value[6 + valueArray2.length];
        int n3 = 0;
        valueArray3[n3++] = value2;
        valueArray3[n3++] = object2;
        valueArray3[n3++] = valueArray != null ? valueArray[0] : null;
        valueArray3[n3++] = valueArray != null ? valueArray[1] : null;
        valueArray3[n3++] = object;
        valueArray3[n3++] = value;
        for (int i = 0; i < valueArray2.length; ++i) {
            valueArray3[n3++] = valueArray2[i];
        }
        return new Value<Value[], Paint>(valueArray3, PaintConverter.RadialGradientConverter.getInstance());
    }

    private Value parseRadialGradient(Term term) throws ParseException {
        Value<Value[], Stop>[] valueArray;
        Object object;
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"radial-gradient".regionMatches(true, 0, string, 0, 15)) {
            this.error(term, "Expected 'radial-gradient'");
        }
        if ((term2 = term.firstArg) == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term, "Expected 'focus-angle <angle>' or 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
        }
        Term term3 = term2;
        Value value = null;
        Value value2 = null;
        Value[] valueArray2 = null;
        Value<?, Size> value3 = null;
        if ("focus-angle".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '<angle>'");
            }
            object = this.size(term2.token);
            switch (object.getUnits()) {
                case DEG: 
                case RAD: 
                case GRAD: 
                case TURN: 
                case PX: {
                    break;
                }
                default: {
                    this.error(term2, "Expected [deg | rad | grad | turn ]");
                }
            }
            value = new Value(object, null);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'focus-distance <percentage>' or 'center <point>' or 'radius [<length> | <percentage>]'");
            }
        }
        if ("focus-distance".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '<percentage>'");
            }
            object = this.size(term2.token);
            switch (object.getUnits()) {
                case PERCENT: {
                    break;
                }
                default: {
                    this.error(term2, "Expected '%'");
                }
            }
            value2 = new Value((Size)object, null);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'center <center>' or 'radius <length>'");
            }
        }
        if ("center".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            object = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null) {
                this.error(term3, "Expected '<point>'");
            }
            valueArray = this.parseSize(term2);
            valueArray2 = new Value[]{object, valueArray};
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        if ("radius".equalsIgnoreCase(term2.token.getText())) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || !this.isSize(term2.token)) {
                this.error(term3, "Expected '[<length> | <percentage>]'");
            }
            value3 = this.parseSize(term2);
            term3 = term2;
            term2 = term2.nextArg;
            if (term2 == null) {
                this.error(term3, "Expected 'radius [<length> | <percentage>]'");
            }
        }
        object = CycleMethod.NO_CYCLE;
        if ("reflect".equalsIgnoreCase(term2.token.getText())) {
            object = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        } else if ("repeat".equalsIgnoreCase(term2.token.getText())) {
            object = CycleMethod.REFLECT;
            term3 = term2;
            term2 = term2.nextArg;
        }
        if (term2 == null || term2.token == null || term2.token.getText().isEmpty()) {
            this.error(term3, "Expected '<color-stop>'");
        }
        valueArray = this.parseColorStops(term2);
        Value[] valueArray3 = new Value[6 + valueArray.length];
        int n = 0;
        valueArray3[n++] = value;
        valueArray3[n++] = value2;
        valueArray3[n++] = valueArray2 != null ? valueArray2[0] : null;
        valueArray3[n++] = valueArray2 != null ? valueArray2[1] : null;
        valueArray3[n++] = value3;
        valueArray3[n++] = new Value((Size)object, null);
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray3[n++] = valueArray[i];
        }
        return new Value<Value[], Paint>(valueArray3, PaintConverter.RadialGradientConverter.getInstance());
    }

    private Value<Value<?, Paint>[], Paint[]> parsePaintLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        Term term2 = term;
        int n2 = 0;
        do {
            if (term2.token == null || term2.token.getText() == null || term2.token.getText().isEmpty()) {
                this.error(term2, "Expected '<paint>'");
            }
            valueArray[n2++] = this.parse(term2);
        } while ((term2 = this.nextLayer(term2)) != null);
        return new Value<Value<?, Paint>[], Paint[]>(valueArray, PaintConverter.SequenceConverter.getInstance());
    }

    private Value<?, Size>[] parseSizeSeries(Term term) throws ParseException {
        Term term2 = term;
        Value[] valueArray = new Value[4];
        int n = 0;
        while (n < 4 && term2 != null) {
            valueArray[n++] = this.parseSize(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            valueArray[1] = valueArray[0];
        }
        if (n < 3) {
            valueArray[2] = valueArray[0];
        }
        if (n < 4) {
            valueArray[3] = valueArray[1];
        }
        return valueArray;
    }

    private Value<Value<Value<?, Size>[], Insets>[], Insets[]> parseInsetsLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        Value[] valueArray = new Value[n];
        while (term2 != null) {
            Value<?, Size>[] valueArray2 = this.parseSizeSeries(term2);
            valueArray[n2++] = new Value<Value<?, Size>[], Insets>(valueArray2, InsetsConverter.getInstance());
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value<?, Size>[], Insets>[], Insets[]>(valueArray, InsetsConverter.SequenceConverter.getInstance());
    }

    private Value<Value<Value<?, Size>[], Margins>[], Margins[]> parseMarginsLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        Value[] valueArray = new Value[n];
        while (term2 != null) {
            Value<?, Size>[] valueArray2 = this.parseSizeSeries(term2);
            valueArray[n2++] = new Value<Value<?, Size>[], Margins>(valueArray2, Margins.Converter.getInstance());
            while (term2.nextInSeries != null) {
                term2 = term2.nextInSeries;
            }
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value<?, Size>[], Margins>[], Margins[]>(valueArray, Margins.SequenceConverter.getInstance());
    }

    private Value<Value<?, Size>[], BackgroundImage.BackgroundPosition> parseBackgroundPosition(Term term) throws ParseException {
        Value[] valueArray;
        Object object;
        if (term.token == null || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<bg-position>'");
        }
        Term term2 = term;
        Token token = term.token;
        Term term3 = term2.nextInSeries;
        Token token2 = term3 != null ? term3.token : null;
        Term term4 = term3 != null ? term3.nextInSeries : null;
        Token token3 = term4 != null ? term4.token : null;
        Term term5 = term4 != null ? term4.nextInSeries : null;
        Token token4 = term5 != null ? term5.token : null;
        Object object2 = ZERO_PERCENT;
        Value[] valueArray2 = object = ZERO_PERCENT;
        Object object3 = object;
        if (token2 != null && token3 != null) {
            String string;
            if (token2.getType() == 11) {
                if (token4 != null) {
                    this.error(term3, "Unexpected value in '<bg-position>'");
                }
                token4 = token3;
                term5 = term4;
                token3 = token2;
                term4 = term3;
                token2 = null;
                term3 = null;
            }
            if (token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
            valueArray = null;
            if (token2 != null && this.isSize(token2)) {
                valueArray = this.parseSize(term3);
            } else {
                this.error(term3, "Expected '<size>'");
            }
            if (token3.getType() != 11 || token3.getText() == null || token3.getText().isEmpty()) {
                this.error(term4, "Expected 'center', 'left' or 'right'");
            }
            Value<?, Size> value = null;
            if (token4 != null) {
                if (this.isSize(token4)) {
                    value = this.parseSize(term5);
                } else {
                    this.error(term5, "Expected '<size>'");
                }
            }
            if ("center".equals(string = token.getText().toLowerCase())) {
                object2 = FIFTY_PERCENT;
                if (valueArray != null) {
                    this.error(term3, "Unexpected '<size>'");
                }
            } else if ("left".equals(string)) {
                object2 = valueArray != null ? valueArray : ZERO_PERCENT;
            } else if ("right".equals(string)) {
                if (valueArray != null) {
                    valueArray2 = valueArray;
                } else {
                    object2 = ONE_HUNDRED_PERCENT;
                }
            } else {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
            if ("center".equals(string = token3.getText().toLowerCase())) {
                object3 = FIFTY_PERCENT;
                if (value != null) {
                    this.error(term5, "Unexpected '<size>'");
                }
            } else if ("top".equals(string)) {
                object3 = value != null ? value : ZERO_PERCENT;
            } else if ("bottom".equals(string)) {
                if (value != null) {
                    object = value;
                } else {
                    object3 = ONE_HUNDRED_PERCENT;
                }
            } else {
                this.error(term4, "Expected 'center', 'left' or 'right'");
            }
        } else if (token2 != null) {
            if (token.getType() == 11) {
                Value[] valueArray3 = valueArray = token.getText() != null ? token.getText().toLowerCase() : null;
                if ("center".equals(valueArray)) {
                    object2 = FIFTY_PERCENT;
                } else if ("left".equals(valueArray)) {
                    object2 = ZERO_PERCENT;
                } else if ("right".equals(valueArray)) {
                    object2 = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term2, "Expected 'center', 'left' or 'right'");
                }
            } else if (this.isSize(token)) {
                object2 = this.parseSize(term2);
            } else {
                this.error(term2, "Expected '<size>', 'center', 'left' or 'right'");
            }
            if (token2.getType() == 11) {
                Value[] valueArray4 = valueArray = token2.getText() != null ? token2.getText().toLowerCase() : null;
                if ("center".equals(valueArray)) {
                    object3 = FIFTY_PERCENT;
                } else if ("top".equals(valueArray)) {
                    object3 = ZERO_PERCENT;
                } else if ("bottom".equals(valueArray)) {
                    object3 = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term3, "Expected 'center', 'left' or 'right'");
                }
            } else if (this.isSize(token2)) {
                object3 = this.parseSize(term3);
            } else {
                this.error(term3, "Expected '<size>', 'center', 'left' or 'right'");
            }
        } else if (token.getType() == 11) {
            Value[] valueArray5 = valueArray = token.getText() != null ? token.getText().toLowerCase() : null;
            if ("center".equals(valueArray)) {
                object2 = FIFTY_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("left".equals(valueArray)) {
                object2 = ZERO_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("right".equals(valueArray)) {
                object2 = ONE_HUNDRED_PERCENT;
                object3 = FIFTY_PERCENT;
            } else if ("top".equals(valueArray)) {
                object3 = ZERO_PERCENT;
                object2 = FIFTY_PERCENT;
            } else if ("bottom".equals(valueArray)) {
                object3 = ONE_HUNDRED_PERCENT;
                object2 = FIFTY_PERCENT;
            } else {
                this.error(term2, "Expected 'center', 'left' or 'right'");
            }
        } else if (this.isSize(token)) {
            object2 = this.parseSize(term2);
            object3 = FIFTY_PERCENT;
        } else {
            this.error(term2, "Expected '<size>', 'center', 'left' or 'right'");
        }
        valueArray = new Value[]{object3, valueArray2, object, object2};
        return new Value<Value<?, Size>[], BackgroundImage.BackgroundPosition>(valueArray, BackgroundImage.BackgroundPositionConverter.getInstance());
    }

    private Value<Value<Value<?, Size>[], BackgroundImage.BackgroundPosition>[], BackgroundImage.BackgroundPosition[]> parseBackgroundPositionLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseBackgroundPosition(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value<?, Size>[], BackgroundImage.BackgroundPosition>[], BackgroundImage.BackgroundPosition[]>(valueArray, BackgroundImage.LayeredBackgroundPositionConverter.getInstance());
    }

    private Value<Repeat[], Repeat[]> parseRepeatStyle(Term term) throws ParseException {
        String string;
        Repeat repeat;
        Repeat repeat2 = repeat = Repeat.NO_REPEAT;
        Term term2 = term;
        if (term2.token == null || term2.token.getType() != 11 || term2.token.getText() == null || term2.token.getText().isEmpty()) {
            this.error(term2, "Expected '<repeat-style>'");
        }
        if ("repeat-x".equals(string = term2.token.getText().toLowerCase())) {
            repeat2 = Repeat.REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else if ("repeat-y".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.REPEAT;
        } else if ("repeat".equals(string)) {
            repeat2 = Repeat.REPEAT;
            repeat = Repeat.REPEAT;
        } else if ("space".equals(string)) {
            repeat2 = Repeat.SPACE;
            repeat = Repeat.SPACE;
        } else if ("round".equals(string)) {
            repeat2 = Repeat.ROUND;
            repeat = Repeat.ROUND;
        } else if ("no-repeat".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else if ("stretch".equals(string)) {
            repeat2 = Repeat.NO_REPEAT;
            repeat = Repeat.NO_REPEAT;
        } else {
            this.error(term2, "Expected  '<repeat-style>' " + string);
        }
        term2 = term2.nextInSeries;
        if (term2 != null && term2.token != null && term2.token.getType() == 11 && term2.token.getText() != null && !term2.token.getText().isEmpty()) {
            string = term2.token.getText().toLowerCase();
            if ("repeat-x".equals(string)) {
                this.error(term2, "Unexpected 'repeat-x'");
            } else if ("repeat-y".equals(string)) {
                this.error(term2, "Unexpected 'repeat-y'");
            } else if ("repeat".equals(string)) {
                repeat = Repeat.REPEAT;
            } else if ("space".equals(string)) {
                repeat = Repeat.SPACE;
            } else if ("round".equals(string)) {
                repeat = Repeat.ROUND;
            } else if ("no-repeat".equals(string)) {
                repeat = Repeat.NO_REPEAT;
            } else if ("stretch".equals(string)) {
                repeat = Repeat.NO_REPEAT;
            } else {
                this.error(term2, "Expected  '<repeat-style>'");
            }
        }
        return new Value<Repeat[], Repeat[]>(new Repeat[]{repeat2, repeat}, null);
    }

    private Value<Value<Repeat[], Repeat[]>[], BorderImage.BorderImageRepeat[]> parseBorderImageRepeatStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseRepeatStyle(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Repeat[], Repeat[]>[], BorderImage.BorderImageRepeat[]>(valueArray, BorderImage.RepeatConverter.getInstance());
    }

    private Value<Value<Repeat[], Repeat[]>[], BackgroundImage.BackgroundRepeat[]> parseBackgroundRepeatStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseRepeatStyle(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Repeat[], Repeat[]>[], BackgroundImage.BackgroundRepeat[]>(valueArray, BackgroundImage.BackgroundRepeatConverter.getInstance());
    }

    private Value<Value[], BackgroundImage.BackgroundSize> parseBackgroundSize(Term term) throws ParseException {
        Value[] valueArray;
        Value<Size, Size> value = ZERO_PERCENT;
        Value<Size, Size> value2 = ZERO_PERCENT;
        boolean bl = false;
        boolean bl2 = false;
        Term term2 = term;
        if (term2.token == null) {
            this.error(term2, "Expected '<bg-size>'");
        }
        if (term2.token.getType() == 11) {
            Value[] valueArray2 = valueArray = term2.token.getText() != null ? term2.token.getText().toLowerCase() : null;
            if ("auto".equals(valueArray)) {
                value2 = ZERO_PERCENT;
                value = ZERO_PERCENT;
            } else if ("cover".equals(valueArray)) {
                bl = true;
            } else if ("contain".equals(valueArray)) {
                bl2 = true;
            } else if ("stretch".equals(valueArray)) {
                value2 = ONE_HUNDRED_PERCENT;
                value = ONE_HUNDRED_PERCENT;
            } else {
                this.error(term2, "Expected 'auto', 'cover', 'contain', or  'stretch'");
            }
        } else if (this.isSize(term2.token)) {
            value2 = this.parseSize(term2);
            value = ZERO_PERCENT;
        } else {
            this.error(term2, "Expected '<bg-size>'");
        }
        term2 = term2.nextInSeries;
        if (term2 != null) {
            if (bl || bl2) {
                this.error(term2, "Unexpected '<bg-size>'");
            }
            if (term2.token.getType() == 11) {
                Value[] valueArray3 = valueArray = term2.token.getText() != null ? term2.token.getText().toLowerCase() : null;
                if ("auto".equals(valueArray)) {
                    value = ZERO_PERCENT;
                } else if ("cover".equals(valueArray)) {
                    this.error(term2, "Unexpected 'cover'");
                } else if ("contain".equals(valueArray)) {
                    this.error(term2, "Unexpected 'contain'");
                } else if ("stretch".equals(valueArray)) {
                    value = ONE_HUNDRED_PERCENT;
                } else {
                    this.error(term2, "Expected 'auto' or 'stretch'");
                }
            } else if (this.isSize(term2.token)) {
                value = this.parseSize(term2);
            } else {
                this.error(term2, "Expected '<bg-size>'");
            }
        }
        valueArray = new Value[]{value2, value, new Value<String, Boolean>(bl ? "true" : "false", BooleanConverter.getInstance()), new Value<String, Boolean>(bl2 ? "true" : "false", BooleanConverter.getInstance())};
        return new Value<Value[], BackgroundImage.BackgroundSize>(valueArray, BackgroundImage.BackgroundSizeConverter.getInstance());
    }

    private Value<Value<Value[], BackgroundImage.BackgroundSize>[], BackgroundImage.BackgroundSize[]> parseBackgroundSizeLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseBackgroundSize(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value[], BackgroundImage.BackgroundSize>[], BackgroundImage.BackgroundSize[]>(valueArray, BackgroundImage.LayeredBackgroundSizeConverter.getInstance());
    }

    private Value<Value<?, Paint>[], Paint[]> parseBorderPaint(Term term) throws ParseException {
        Term term2 = term;
        Value[] valueArray = new Value[4];
        int n = 0;
        while (term2 != null) {
            if (term2.token == null) {
                this.error(term2, "Expected '<paint>'");
            }
            valueArray[n++] = this.parse(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            valueArray[1] = valueArray[0];
        }
        if (n < 3) {
            valueArray[2] = valueArray[0];
        }
        if (n < 4) {
            valueArray[3] = valueArray[1];
        }
        return new Value<Value<?, Paint>[], Paint[]>(valueArray, StrokeBorder.BorderPaintConverter.getInstance());
    }

    private Value<Value<Value<?, Paint>[], Paint[]>[], Paint[][]> parseBorderPaintLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseBorderPaint(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value<?, Paint>[], Paint[]>[], Paint[][]>(valueArray, StrokeBorder.LayeredBorderPaintConverter.getInstance());
    }

    private Value<Value<Value[], BorderStyle>[], BorderStyle[]> parseBorderStyleSeries(Term term) throws ParseException {
        Term term2 = term;
        Value[] valueArray = new Value[4];
        int n = 0;
        while (term2 != null) {
            valueArray[n++] = this.parseBorderStyle(term2);
            term2 = term2.nextInSeries;
        }
        if (n < 2) {
            valueArray[1] = valueArray[0];
        }
        if (n < 3) {
            valueArray[2] = valueArray[0];
        }
        if (n < 4) {
            valueArray[3] = valueArray[1];
        }
        return new Value<Value<Value[], BorderStyle>[], BorderStyle[]>(valueArray, StrokeBorder.BorderStyleSequenceConverter.getInstance());
    }

    private Value<Value<Value<Value[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]> parseBorderStyleLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseBorderStyleSeries(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value<Value[], BorderStyle>[], BorderStyle[]>[], BorderStyle[][]>(valueArray, StrokeBorder.LayeredBorderStyleConverter.getInstance());
    }

    private String getKeyword(Term term) {
        if (term != null && term.token != null && term.token.getType() == 11 && term.token.getText() != null && !term.token.getText().isEmpty()) {
            return term.token.getText().toLowerCase();
        }
        return null;
    }

    private Value<Value[], BorderStyle> parseBorderStyle(Term term) throws ParseException {
        Value[] valueArray;
        Value<Value<?, Size>[], Double[]> value = null;
        Value value2 = null;
        Value<String, StrokeType> value3 = null;
        Value value4 = null;
        Value value5 = null;
        Value<String, StrokeLineCap> value6 = null;
        Term term2 = term;
        value = this.dashStyle(term2);
        Term term3 = term2;
        term2 = term2.nextInSeries;
        String string = this.getKeyword(term2);
        if ("phase".equals(string)) {
            term3 = term2;
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null || !this.isSize(term2.token)) {
                this.error(term2, "Expected '<size>'");
            }
            valueArray = this.parseSize(term2);
            value2 = new Value((Value<?, Size>)valueArray, SizeConverter.getInstance());
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if ((value3 = this.parseStrokeType(term2)) != null) {
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if ("line-join".equals(string = this.getKeyword(term2))) {
            term3 = term2;
            term2 = term2.nextInSeries;
            valueArray = this.parseStrokeLineJoin(term2);
            if (valueArray != null) {
                value4 = valueArray[0];
                value5 = valueArray[1];
            } else {
                this.error(term2, "Expected 'miter <size>?', 'bevel' or 'round'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
            string = this.getKeyword(term2);
        }
        if ("line-cap".equals(string)) {
            term3 = term2;
            term2 = term2.nextInSeries;
            value6 = this.parseStrokeLineCap(term2);
            if (value6 == null) {
                this.error(term2, "Expected 'square', 'butt' or 'round'");
            }
            term3 = term2;
            term2 = term2.nextInSeries;
        }
        if (term2 != null) {
            term.nextInSeries = term2;
        } else {
            term.nextInSeries = null;
            term.nextLayer = term3.nextLayer;
        }
        valueArray = new Value[]{value, value2, value3, value4, value5, value6};
        return new Value<Value[], BorderStyle>(valueArray, StrokeBorder.BorderStyleConverter.getInstance());
    }

    private Value<Value<?, Size>[], Double[]> dashStyle(Term term) throws ParseException {
        if (term.token == null) {
            this.error(term, "Expected '<dash-style>'");
        }
        int n = term.token.getType();
        Value<Value<?, Size>[], Double[]> value = null;
        if (n == 11) {
            value = this.borderStyle(term);
        } else if (n == 12) {
            value = this.segments(term);
        } else {
            this.error(term, "Expected '<dash-style>'");
        }
        return value;
    }

    private Value<Value<?, Size>[], Double[]> borderStyle(Term term) throws ParseException {
        String string;
        if (term.token == null || term.token.getType() != 11 || term.token.getText() == null || term.token.getText().isEmpty()) {
            this.error(term, "Expected '<border-style>'");
        }
        if ("none".equals(string = term.token.getText().toLowerCase())) {
            return NONE;
        }
        if ("hidden".equals(string)) {
            return NONE;
        }
        if ("dotted".equals(string)) {
            return DOTTED;
        }
        if ("dashed".equals(string)) {
            return DASHED;
        }
        if ("solid".equals(string)) {
            return SOLID;
        }
        if ("double".equals(string)) {
            this.error(term, "Unsupported <border-style> 'double'");
        } else if ("groove".equals(string)) {
            this.error(term, "Unsupported <border-style> 'groove'");
        } else if ("ridge".equals(string)) {
            this.error(term, "Unsupported <border-style> 'ridge'");
        } else if ("inset".equals(string)) {
            this.error(term, "Unsupported <border-style> 'inset'");
        } else if ("outset".equals(string)) {
            this.error(term, "Unsupported <border-style> 'outset'");
        } else {
            this.error(term, "Unsupported <border-style> '" + string + "'");
        }
        return SOLID;
    }

    private Value<Value<?, Size>[], Double[]> segments(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"segments".regionMatches(true, 0, string, 0, 8)) {
            this.error(term, "Expected 'segments'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term2, "Expected '<size>'");
        }
        int n = this.numberOfArgs(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        while (term2 != null) {
            valueArray[n2++] = this.parseSize(term2);
            term2 = term2.nextArg;
        }
        return new Value<Value<?, Size>[], Double[]>(valueArray, SizeConverter.SequenceConverter.getInstance());
    }

    private Value<String, StrokeType> parseStrokeType(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("centered".equals(string) || "inside".equals(string) || "outside".equals(string)) {
            return new Value<String, StrokeType>(string, new EnumConverter(StrokeType.class));
        }
        return null;
    }

    private Value[] parseStrokeLineJoin(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("miter".equals(string) || "bevel".equals(string) || "round".equals(string)) {
            Term term2;
            Value value = new Value(string, new EnumConverter(StrokeLineJoin.class));
            Value value2 = null;
            if ("miter".equals(string) && (term2 = term.nextInSeries) != null && term2.token != null && this.isSize(term2.token)) {
                term.nextInSeries = term2.nextInSeries;
                Value<?, Size> value3 = this.parseSize(term2);
                value2 = new Value(value3, SizeConverter.getInstance());
            }
            return new Value[]{value, value2};
        }
        return null;
    }

    private Value<String, StrokeLineCap> parseStrokeLineCap(Term term) throws ParseException {
        String string = this.getKeyword(term);
        if ("square".equals(string) || "butt".equals(string) || "round".equals(string)) {
            return new Value<String, StrokeLineCap>(string, new EnumConverter(StrokeLineCap.class));
        }
        return null;
    }

    private Value<Value[], BorderImage.BorderImageSlice> parseBorderImageSlice(Term term) throws ParseException {
        Term term2 = term;
        if (term2.token == null || !this.isSize(term2.token)) {
            this.error(term2, "Expected '<size>'");
        }
        Value[] valueArray = new Value[4];
        Boolean bl = Boolean.FALSE;
        int n = 0;
        while (n < 4 && term2 != null) {
            valueArray[n++] = this.parseSize(term2);
            term2 = term2.nextInSeries;
            if (term2 == null || term2.token == null || term2.token.getType() != 11 || !"fill".equalsIgnoreCase(term2.token.getText())) continue;
            bl = Boolean.TRUE;
            break;
        }
        if (n < 2) {
            valueArray[1] = valueArray[0];
        }
        if (n < 3) {
            valueArray[2] = valueArray[0];
        }
        if (n < 4) {
            valueArray[3] = valueArray[1];
        }
        Value[] valueArray2 = new Value[]{new Value<Value<?, Size>[], Insets>(valueArray, InsetsConverter.getInstance()), new Value(bl, null)};
        return new Value<Value[], BorderImage.BorderImageSlice>(valueArray2, BorderImage.SliceConverter.getInstance());
    }

    private Value<Value<Value[], BorderImage.BorderImageSlice>[], BorderImage.BorderImageSlice[]> parseBorderImageSliceLayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Value[] valueArray = new Value[n];
        int n2 = 0;
        Term term2 = term;
        while (term2 != null) {
            valueArray[n2++] = this.parseBorderImageSlice(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value[], BorderImage.BorderImageSlice>[], BorderImage.BorderImageSlice[]>(valueArray, BorderImage.SliceSequenceConverter.getInstance());
    }

    private Value<Value[], String> parseURI(Term term) throws ParseException {
        Term term2;
        String string;
        String string2 = string = term.token != null ? term.token.getText() : null;
        if (!"url".regionMatches(true, 0, string, 0, 3)) {
            this.error(term, "Expected 'url'");
        }
        if ((term2 = term.firstArg) == null) {
            this.error(term, "Expected 'url(\"<uri-string>\")'");
        }
        if (term2.token == null || term2.token.getType() != 10 || term2.token.getText() == null || term2.token.getText().isEmpty()) {
            this.error(term2, "Excpected 'url(\"<uri-string>\")'");
        }
        String string3 = term2.token.getText();
        Value[] valueArray = new Value[]{new Value<String, String>(string3, StringConverter.getInstance()), new Value(this.stylesheet.getUrl(), null)};
        return new Value<Value[], String>(valueArray, URLConverter.getInstance());
    }

    private Value<Value<Value[], String>[], String[]> parseURILayers(Term term) throws ParseException {
        int n = this.numberOfLayers(term);
        Term term2 = term;
        int n2 = 0;
        Value[] valueArray = new Value[n];
        while (term2 != null) {
            valueArray[n2++] = this.parseURI(term2);
            term2 = this.nextLayer(term2);
        }
        return new Value<Value<Value[], String>[], String[]>(valueArray, URLConverter.SequenceConverter.getInstance());
    }

    private Value<Value<?, Size>, Double> parseFontSize(Term term) throws ParseException {
        Object object;
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || !this.isSize(token)) {
            this.error(term, "Expected '<font-size>'");
        }
        Size size = null;
        if (token.getType() == 11) {
            object = token.getText().toLowerCase();
            double d = -1.0;
            if ("inherit".equals(object)) {
                d = 100.0;
            } else if ("xx-small".equals(object)) {
                d = 60.0;
            } else if ("x-small".equals(object)) {
                d = 75.0;
            } else if ("small".equals(object)) {
                d = 80.0;
            } else if ("medium".equals(object)) {
                d = 100.0;
            } else if ("large".equals(object)) {
                d = 120.0;
            } else if ("x-large".equals(object)) {
                d = 150.0;
            } else if ("xx-large".equals(object)) {
                d = 200.0;
            } else if ("smaller".equals(object)) {
                d = 80.0;
            } else if ("larger".equals(object)) {
                d = 120.0;
            }
            if (d > -1.0) {
                size = new Size(d, SizeUnits.PERCENT);
            }
        }
        if (size == null) {
            size = this.size(token);
        }
        object = new Value(size, null);
        return new Value(object, SizeConverter.getInstance());
    }

    private Value<FontUnits.Style, FontPosture> parseFontStyle(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error(term, "Expected '<font-style>'");
        }
        String string = token.getText().toLowerCase();
        FontUnits.Style style = null;
        if ("normal".equals(string)) {
            style = FontUnits.Style.NORMAL;
        } else if ("italic".equals(string)) {
            style = FontUnits.Style.ITALIC;
        } else if ("oblique".equals(string)) {
            style = FontUnits.Style.OBLIQUE;
        } else if ("inherit".equals(string)) {
            style = FontUnits.Style.OBLIQUE;
        } else {
            return null;
        }
        return new Value<FontUnits.Style, FontPosture>(style, FontConverter.StyleConverter.getInstance());
    }

    private Value<FontUnits.Weight, FontWeight> parseFontWeight(Term term) throws ParseException {
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || token.getType() != 11 || token.getText() == null || token.getText().isEmpty()) {
            this.error(term, "Expected '<font-weight>'");
        }
        String string = token.getText().toLowerCase();
        FontUnits.Weight weight = null;
        if ("inherit".equals(string)) {
            weight = FontUnits.Weight.INHERIT;
        } else if ("normal".equals(string)) {
            weight = FontUnits.Weight.NORMAL;
        } else if ("bold".equals(string)) {
            weight = FontUnits.Weight.BOLD;
        } else if ("bolder".equals(string)) {
            weight = FontUnits.Weight.BOLDER;
        } else if ("lighter".equals(string)) {
            weight = FontUnits.Weight.LIGHTER;
        } else if ("100".equals(string)) {
            weight = FontUnits.Weight.SCALE_100;
        } else if ("200".equals(string)) {
            weight = FontUnits.Weight.SCALE_200;
        } else if ("300".equals(string)) {
            weight = FontUnits.Weight.SCALE_300;
        } else if ("400".equals(string)) {
            weight = FontUnits.Weight.SCALE_400;
        } else if ("500".equals(string)) {
            weight = FontUnits.Weight.SCALE_500;
        } else if ("600".equals(string)) {
            weight = FontUnits.Weight.SCALE_600;
        } else if ("700".equals(string)) {
            weight = FontUnits.Weight.SCALE_700;
        } else if ("800".equals(string)) {
            weight = FontUnits.Weight.SCALE_800;
        } else {
            return null;
        }
        return new Value<FontUnits.Weight, FontWeight>(weight, FontConverter.WeightConverter.getInstance());
    }

    private Value<String, String> parseFontFamily(Term term) throws ParseException {
        String string;
        if (term == null) {
            return null;
        }
        Token token = term.token;
        if (token == null || token.getType() != 11 && token.getType() != 10 || token.getText() == null || token.getText().isEmpty()) {
            this.error(term, "Expected '<font-family>'");
        }
        if ("inherit".equals(string = token.getText().toLowerCase())) {
            return new Value<String, String>("inherit", StringConverter.getInstance());
        }
        if ("serif".equals(string) || "sans-serif".equals(string) || "cursive".equals(string) || "fantasy".equals(string) || "monospace".equals(string)) {
            return new Value<String, String>(string, StringConverter.getInstance());
        }
        return new Value<String, String>(token.getText(), StringConverter.getInstance());
    }

    private Value<Value[], Font> parseFont(Term term) throws ParseException {
        Value<Value<?, Size>, Double> value;
        Term term2;
        Object object;
        Object object2 = term.nextInSeries;
        term.nextInSeries = null;
        while (object2 != null) {
            object = ((Term)object2).nextInSeries;
            ((Term)object2).nextInSeries = term;
            term = object2;
            object2 = object;
        }
        object = term.token;
        int n = ((Token)object).getType();
        if (n != 11 && n != 10) {
            this.error(term, "Expected '<font-family>'");
        }
        Value<String, String> value2 = this.parseFontFamily(term);
        Term term3 = term;
        term3 = term3.nextInSeries;
        if (term3 == null) {
            this.error(term, "Expected '<size>'");
        }
        if (term3.token == null || !this.isSize(term3.token)) {
            this.error(term3, "Expected '<size>'");
        }
        if ((term2 = term3.nextInSeries) != null && term2.token != null && term2.token.getType() == 32) {
            term = term2;
            term3 = term2.nextInSeries;
            if (term3 == null) {
                this.error(term, "Expected '<size>'");
            }
            if (term3.token == null || !this.isSize(term3.token)) {
                this.error(term3, "Expected '<size>'");
            }
            object = term3.token;
        }
        if ((value = this.parseFontSize(term3)) == null) {
            this.error(term, "Expected '<size>'");
        }
        Value<FontUnits.Style, FontPosture> value3 = null;
        Value<FontUnits.Weight, FontWeight> value4 = null;
        String string = null;
        while ((term3 = term3.nextInSeries) != null) {
            if (term3.token == null || term3.token.getType() != 11 || term3.token.getText() == null || term3.token.getText().isEmpty()) {
                this.error(term3, "Expected '<font-weight>', '<font-style>' or '<font-variant>'");
            }
            if (value3 == null && (value3 = this.parseFontStyle(term3)) != null) continue;
            if (string == null && "small-caps".equalsIgnoreCase(term3.token.getText())) {
                string = term3.token.getText();
                continue;
            }
            if (value4 != null || (value4 = this.parseFontWeight(term3)) == null) continue;
        }
        Value[] valueArray = new Value[]{value2, value, value4, value3};
        return new Value<Value[], Font>(valueArray, FontConverter.getInstance());
    }

    private Token nextToken(CSSLexer cSSLexer) {
        Token token = null;
        while ((token = cSSLexer.nextToken()) != null && token.getType() == 40 || token.getType() == 41) {
        }
        if (LOGGER.isLoggable(300)) {
            LOGGER.finest(token.toString());
        }
        return token;
    }

    private void parse(CSSLexer cSSLexer) {
        this.currentToken = this.nextToken(cSSLexer);
        while (this.currentToken != null && this.currentToken.getType() != -1) {
            List<Selector> list = this.selectors(cSSLexer);
            if (list == null) {
                return;
            }
            if (this.currentToken == null || this.currentToken.getType() != 28) {
                if (LOGGER.isLoggable(900)) {
                    int n = this.currentToken != null ? this.currentToken.getLine() : -1;
                    int n2 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                    String string = this.stylesheet.getUrl() != null ? this.stylesheet.getUrl().toExternalForm() : "?";
                    LOGGER.warning("Expected LBRACE at {0}[{1,number,integer},{2,number,integer}]", string, n, n2);
                }
                this.currentToken = null;
                return;
            }
            this.currentToken = this.nextToken(cSSLexer);
            List<Declaration> list2 = this.declarations(cSSLexer);
            if (list2 == null) {
                return;
            }
            if (this.currentToken != null && this.currentToken.getType() != 29) {
                if (LOGGER.isLoggable(900)) {
                    int n = this.currentToken != null ? this.currentToken.getLine() : -1;
                    int n3 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                    String string = this.stylesheet.getUrl() != null ? this.stylesheet.getUrl().toExternalForm() : "?";
                    LOGGER.warning("Expected RBRACE at {0}[{1,number,integer},{2,number,integer}]", string, n, n3);
                }
                this.currentToken = null;
                return;
            }
            this.stylesheet.addRule(new Rule(list, list2));
            this.currentToken = this.nextToken(cSSLexer);
        }
        this.currentToken = null;
    }

    private List<Selector> selectors(CSSLexer cSSLexer) {
        ArrayList<Selector> arrayList = new ArrayList<Selector>();
        while (true) {
            Selector selector;
            if ((selector = this.selector(cSSLexer)) == null) {
                while (this.currentToken != null && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cSSLexer);
                }
                this.currentToken = this.nextToken(cSSLexer);
                if (this.currentToken != null && this.currentToken.getType() != -1) continue;
                this.currentToken = null;
                return null;
            }
            arrayList.add(selector);
            if (this.currentToken == null || this.currentToken.getType() != 36) break;
            this.currentToken = this.nextToken(cSSLexer);
        }
        return arrayList;
    }

    private Selector selector(CSSLexer cSSLexer) {
        Combinator combinator;
        ArrayList<Combinator> arrayList = null;
        ArrayList<SimpleSelector> arrayList2 = null;
        SimpleSelector simpleSelector = this.simpleSelector(cSSLexer);
        if (simpleSelector == null) {
            return null;
        }
        while ((combinator = this.combinator(cSSLexer)) != null) {
            if (arrayList == null) {
                arrayList = new ArrayList<Combinator>();
            }
            arrayList.add(combinator);
            SimpleSelector simpleSelector2 = this.simpleSelector(cSSLexer);
            if (simpleSelector2 == null) {
                return null;
            }
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<SimpleSelector>();
                arrayList2.add(simpleSelector);
            }
            arrayList2.add(simpleSelector2);
        }
        if (this.currentToken != null && this.currentToken.getType() == 41) {
            this.currentToken = this.nextToken(cSSLexer);
        }
        if (arrayList2 == null) {
            return simpleSelector;
        }
        return new CompoundSelector(arrayList2, arrayList);
    }

    private SimpleSelector simpleSelector(CSSLexer cSSLexer) {
        String string = "*";
        String string2 = "";
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        while (true) {
            int n = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n) {
                case 11: 
                case 33: {
                    string = this.currentToken.getText();
                    break;
                }
                case 38: {
                    this.currentToken = this.nextToken(cSSLexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                        }
                        arrayList.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case 37: {
                    string2 = this.currentToken.getText().substring(1);
                    break;
                }
                case 31: {
                    this.currentToken = this.nextToken(cSSLexer);
                    if (this.currentToken != null && this.currentToken.getType() == 11) {
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<String>();
                        }
                        arrayList2.add(this.currentToken.getText());
                        break;
                    }
                    this.currentToken = Token.INVALID_TOKEN;
                    return null;
                }
                case -1: 
                case 27: 
                case 28: 
                case 36: 
                case 40: 
                case 41: {
                    return new SimpleSelector(string, arrayList, arrayList2, string2);
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cSSLexer.nextToken();
            if (!LOGGER.isLoggable(300)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private Combinator combinator(CSSLexer cSSLexer) {
        Combinator combinator = null;
        while (true) {
            int n = this.currentToken != null ? this.currentToken.getType() : 0;
            switch (n) {
                case 40: {
                    if (combinator != null || !" ".equals(this.currentToken.getText())) break;
                    combinator = Combinator.DESCENDANT;
                    break;
                }
                case 27: {
                    combinator = Combinator.CHILD;
                    break;
                }
                case 11: 
                case 31: 
                case 33: 
                case 37: 
                case 38: {
                    return combinator;
                }
                default: {
                    return null;
                }
            }
            this.currentToken = cSSLexer.nextToken();
            if (!LOGGER.isLoggable(300)) continue;
            LOGGER.finest(this.currentToken.toString());
        }
    }

    private List<Declaration> declarations(CSSLexer cSSLexer) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        do {
            Declaration declaration;
            if ((declaration = this.declaration(cSSLexer)) != null) {
                arrayList.add(declaration);
            } else {
                while (this.currentToken != null && this.currentToken.getType() != 30 && this.currentToken.getType() != 29 && this.currentToken.getType() != -1) {
                    this.currentToken = this.nextToken(cSSLexer);
                }
                if (this.currentToken == null && this.currentToken.getType() != 30) {
                    return arrayList;
                }
            }
            if (this.currentToken == null || this.currentToken.getType() != 30) break;
            this.currentToken = this.nextToken(cSSLexer);
        } while (this.currentToken != null && this.currentToken.getType() == 11);
        return arrayList;
    }

    private Declaration declaration(CSSLexer cSSLexer) {
        boolean bl;
        Value value;
        String string;
        block7: {
            int n;
            int n2 = n = this.currentToken != null ? this.currentToken.getType() : 0;
            if (this.currentToken == null || this.currentToken.getType() != 11) {
                if (LOGGER.isLoggable(900)) {
                    int n3 = this.currentToken != null ? this.currentToken.getLine() : -1;
                    int n4 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                    String string2 = this.stylesheet.getUrl() != null ? this.stylesheet.getUrl().toExternalForm() : "?";
                    LOGGER.warning("Expected IDENT at {0}[{1,number,integer},{2,number,integer}]", string2, n3, n4);
                }
                return null;
            }
            string = this.currentToken.getText();
            this.currentToken = this.nextToken(cSSLexer);
            if (this.currentToken == null || this.currentToken.getType() != 31) {
                if (LOGGER.isLoggable(900)) {
                    int n5 = this.currentToken != null ? this.currentToken.getLine() : -1;
                    int n6 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                    String string3 = this.stylesheet.getUrl() != null ? this.stylesheet.getUrl().toExternalForm() : "?";
                    LOGGER.warning("Expected COLON at {0}[{1,number,integer},{2,number,integer}]", string3, n5, n6);
                }
                return null;
            }
            this.currentToken = this.nextToken(cSSLexer);
            Term term = this.expr(cSSLexer);
            value = null;
            try {
                value = term != null ? this.valueFor(string, term) : null;
            }
            catch (ParseException parseException) {
                if (!LOGGER.isLoggable(900)) break block7;
                LOGGER.warning("While parsing declaration: ", parseException);
            }
        }
        boolean bl2 = bl = this.currentToken.getType() == 39;
        if (bl) {
            this.currentToken = this.nextToken(cSSLexer);
        }
        Declaration declaration = value != null ? new Declaration(string, value, bl) : null;
        return declaration;
    }

    private Term expr(CSSLexer cSSLexer) {
        Term term;
        Term term2 = term = this.term(cSSLexer);
        while (true) {
            int n;
            int n2 = n = this.currentToken != null ? this.currentToken.getType() : 0;
            if (n == 30 || n == 39 || n == 29 || n == -1) {
                return term;
            }
            if (n == 36) {
                this.currentToken = this.nextToken(cSSLexer);
                term2 = term2.nextLayer = this.term(cSSLexer);
                continue;
            }
            term2 = term2.nextInSeries = this.term(cSSLexer);
        }
    }

    private Term term(CSSLexer cSSLexer) {
        int n = this.currentToken != null ? this.currentToken.getType() : 0;
        switch (n) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 37: {
                break;
            }
            case 12: 
            case 34: {
                Term term;
                Term term2 = new Term(this.currentToken);
                this.currentToken = this.nextToken(cSSLexer);
                term2.firstArg = term = this.term(cSSLexer);
                while (true) {
                    int n2;
                    int n3 = n2 = this.currentToken != null ? this.currentToken.getType() : 0;
                    if (n2 == 35) {
                        this.currentToken = this.nextToken(cSSLexer);
                        return term2;
                    }
                    if (n2 == 36) {
                        this.currentToken = this.nextToken(cSSLexer);
                        term = term.nextArg = this.term(cSSLexer);
                        continue;
                    }
                    term = term.nextInSeries = this.term(cSSLexer);
                }
            }
            default: {
                if (LOGGER.isLoggable(900)) {
                    int n4 = this.currentToken != null ? this.currentToken.getLine() : -1;
                    int n5 = this.currentToken != null ? this.currentToken.getOffset() : -1;
                    String string = this.currentToken != null ? this.currentToken.getText() : "";
                    URL uRL = this.stylesheet != null ? this.stylesheet.getUrl() : null;
                    String string2 = uRL != null ? uRL.toExternalForm() : "?";
                    LOGGER.warning("Unexpected token {0}{1}{0} at {2}[{3,number,integer},{4,number,integer}]", "'", string, string2, n4, n5);
                }
                return null;
            }
        }
        Term term = new Term(this.currentToken);
        this.currentToken = this.nextToken(cSSLexer);
        return term;
    }

    static {
        int n = LOGGER.getLevel();
        if (LOGGER.getLevel() > 900 && LOGGER.getLevel() != Integer.MAX_VALUE) {
            LOGGER.setLevel(900);
        }
        ZERO_PERCENT = new Value(new Size(0.0, SizeUnits.PERCENT), null);
        FIFTY_PERCENT = new Value(new Size(50.0, SizeUnits.PERCENT), null);
        ONE_HUNDRED_PERCENT = new Value(new Size(100.0, SizeUnits.PERCENT), null);
        DASHED = new Value<Value<?, Size>[], Double[]>(new Value[]{new Value(new Size(5.0, SizeUnits.PX), null), new Value(new Size(3.0, SizeUnits.PX), null)}, SizeConverter.SequenceConverter.getInstance());
        DOTTED = new Value<Value<?, Size>[], Double[]>(new Value[]{new Value(new Size(1.0, SizeUnits.PX), null), new Value(new Size(3.0, SizeUnits.PX), null)}, SizeConverter.SequenceConverter.getInstance());
        SOLID = new Value<Value<?, Size>[], Double[]>(new Value[0], SizeConverter.SequenceConverter.getInstance());
        NONE = new Value<Value<?, Size>[], Double[]>(null, SizeConverter.SequenceConverter.getInstance());
    }

    static class Term {
        final Token token;
        Term nextInSeries;
        Term nextLayer;
        Term firstArg;
        Term nextArg;

        Term(Token token) {
            this.token = token;
            this.nextLayer = null;
            this.nextInSeries = null;
            this.firstArg = null;
            this.nextArg = null;
        }

        Term() {
            this(null);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.token != null) {
                stringBuilder.append(String.valueOf(this.token.getText()));
            }
            if (this.nextInSeries != null) {
                stringBuilder.append("<nextInSeries>");
                stringBuilder.append(this.nextInSeries.toString());
                stringBuilder.append("</nextInSeries>\n");
            }
            if (this.nextLayer != null) {
                stringBuilder.append("<nextLayer>");
                stringBuilder.append(this.nextLayer.toString());
                stringBuilder.append("</nextLayer>\n");
            }
            if (this.firstArg != null) {
                stringBuilder.append("<args>");
                stringBuilder.append(this.firstArg.toString());
                if (this.nextArg != null) {
                    stringBuilder.append(this.nextArg.toString());
                }
                stringBuilder.append("</args>");
            }
            return stringBuilder.toString();
        }
    }

    private static final class ParseException
    extends Exception {
        private final Token tok;

        ParseException(String string) {
            this(string, (Token)null);
        }

        ParseException(String string, Token token) {
            super(string);
            this.tok = token;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(super.getMessage());
            if (this.tok != null) {
                stringBuilder.append(": ").append(this.tok.toString());
            }
            return stringBuilder.toString();
        }
    }

    private static class InstanceHolder {
        static final CSSParser INSTANCE = new CSSParser();

        private InstanceHolder() {
        }
    }
}

