/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections.transformation;

import com.sun.javafx.collections.ListInvalidationListenerWrapper;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class TransformationList<E, F>
extends AbstractList<E>
implements ObservableList<E> {
    protected List<? extends F> source;
    protected final boolean observable;
    private ListChangeListener<F> sourceListener;
    private List<ListChangeListener<? super E>> listeners;

    protected TransformationList(List<? extends F> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        this.source = list;
        if (list instanceof ObservableList) {
            this.observable = true;
            ((ObservableList)list).addListener(this.getListener());
        } else {
            this.observable = false;
        }
    }

    public final List<? extends F> getDirectSource() {
        return this.source;
    }

    public final List<?> getBottomMostSource() {
        List<? extends F> list = this.source;
        while (list instanceof TransformationList) {
            list = ((TransformationList)list).source;
        }
        return list;
    }

    private ListChangeListener<F> getListener() {
        if (this.sourceListener == null) {
            this.sourceListener = new ListChangeListener<F>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends F> change) {
                    TransformationList.this.onSourceChanged(change);
                }
            };
        }
        return this.sourceListener;
    }

    protected abstract void onSourceChanged(ListChangeListener.Change<? extends F> var1);

    @Override
    public final void addListener(InvalidationListener invalidationListener) {
        this.addListener(new ListInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public final void removeListener(InvalidationListener invalidationListener) {
        this.removeListener(new ListInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public final void addListener(ListChangeListener<? super E> listChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ListChangeListener<? super E>>();
        }
        this.listeners.add(listChangeListener);
    }

    @Override
    public final void removeListener(ListChangeListener<? super E> listChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listChangeListener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    public abstract int getSourceIndex(int var1);

    public final int getBottomMostSourceIndex(int n) {
        List<? extends F> list = this.source;
        int n2 = this.getSourceIndex(n);
        while (list instanceof TransformationList) {
            TransformationList transformationList = (TransformationList)list;
            n2 = transformationList.getSourceIndex(n2);
            list = transformationList.source;
        }
        return n2;
    }

    protected void fireChange(ListChangeListener.Change<? extends E> change) {
        if (this.listeners == null) {
            return;
        }
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            change.reset();
            this.listeners.get(i).onChanged(change);
        }
    }
}

