/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.MenuItem;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.mac.MacCommonDialogs;
import com.sun.glass.ui.mac.MacCursor;
import com.sun.glass.ui.mac.MacPixels;
import com.sun.glass.ui.mac.MacRobot;
import com.sun.glass.ui.mac.MacScreen;
import com.sun.glass.ui.mac.MacTimer;
import com.sun.glass.ui.mac.MacView;
import com.sun.glass.ui.mac.MacWindow;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacApplication
extends Application {
    private boolean isEmbedded = false;
    private long shareContextPtr = 0L;
    Menu windowMenu;
    Menu editMenu;
    Menu fileMenu;
    Menu appleMenu;

    private static native void _initIDs();

    native void _runLoop(String[] var1, ClassLoader var2, Launchable var3, boolean var4, long var5);

    @Override
    protected void runLoop(String[] args, Launchable launchable) {
        this.isEmbedded = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean("javafx.macosx.embedded");
            }
        });
        this.shareContextPtr = AccessController.doPrivileged(new PrivilegedAction<Long>(){

            @Override
            public Long run() {
                Object value;
                long ptr = 0L;
                Map deviceDetails = MacApplication.getDeviceDetails();
                if (deviceDetails != null && (value = deviceDetails.get("shareContextPtr")) != null) {
                    ptr = (Long)value;
                }
                return ptr;
            }
        });
        ClassLoader ccl = MacApplication.class.getClassLoader();
        this._runLoop(args, ccl, launchable, this.isEmbedded, this.shareContextPtr);
    }

    private native void _finishTerminating();

    @Override
    protected void finishTerminating() {
        this.setEventThread(null);
        if (!this.isEmbedded) {
            this._finishTerminating();
        }
        super.finishTerminating();
    }

    private void setEventThread() {
        this.setEventThread(Thread.currentThread());
    }

    @Override
    protected native Object _enterNestedEventLoop();

    @Override
    protected native void _leaveNestedEventLoop(Object var1);

    public void installWindowMenu(MenuBar menubar) {
        this.windowMenu = this.createMenu("Window");
        MenuItem closeMenu = this.createMenuItem("Minimize", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuMinimizeWindowAction();
            }
        }, 77, 16);
        this.windowMenu.add(closeMenu);
        MenuItem zoomMenu = this.createMenuItem("Zoom", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuZoomWindowAction();
            }
        });
        this.windowMenu.add(zoomMenu);
        menubar.add(this.windowMenu);
    }

    public Menu getWindowMenu() {
        return this.windowMenu;
    }

    public void installEditMenu(MenuBar menubar) {
        this.editMenu = this.createMenu("Edit");
        MenuItem undoMenu = this.createMenuItem("Undo", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuUndoAction();
            }
        }, 122, 16);
        undoMenu.setEnabled(false);
        this.editMenu.add(undoMenu);
        MenuItem redoMenu = this.createMenuItem("Redo", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuRedoAction();
            }
        }, 122, 17);
        redoMenu.setEnabled(false);
        this.editMenu.add(redoMenu);
        this.editMenu.add(MenuItem.Separator);
        MenuItem copyMenu = this.createMenuItem("Copy", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuCopyAction();
            }
        }, 99, 16);
        this.editMenu.add(copyMenu);
        MenuItem pasteMenu = this.createMenuItem("Paste", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuPasteAction();
            }
        }, 118, 16);
        this.editMenu.add(pasteMenu);
        menubar.add(this.editMenu);
    }

    public Menu getEditMenu() {
        return this.editMenu;
    }

    public void installFileMenu(MenuBar menubar) {
        this.fileMenu = this.createMenu("File");
        MenuItem closeMenu = this.createMenuItem("Close", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuCloseWindowAction();
            }
        }, 119, 16);
        this.fileMenu.add(closeMenu);
        menubar.add(this.fileMenu);
    }

    public Menu getFileMenu() {
        return this.fileMenu;
    }

    public void installAppleMenu(MenuBar menubar) {
        this.appleMenu = this.createMenu("Apple");
        MenuItem aboutMenu = this.createMenuItem("About " + this.getName(), new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuAboutAction();
            }
        });
        this.appleMenu.add(aboutMenu);
        this.appleMenu.add(MenuItem.Separator);
        MenuItem preferencesMenu = this.createMenuItem("Preferences...", new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuPreferencesAction();
            }
        }, 44, 16);
        this.appleMenu.add(preferencesMenu);
        this.appleMenu.add(MenuItem.Separator);
        MenuItem quitMenu = this.createMenuItem("Quit " + this.getName(), new MenuItem.Callback(){

            public void action() {
                MacApplication.this.menuTerminateAction();
            }
        }, 113, 16);
        this.appleMenu.add(quitMenu);
        menubar.add(this.appleMenu);
    }

    public Menu getAppleMenu() {
        return this.appleMenu;
    }

    @Override
    public void installDefaultMenus(MenuBar menubar) {
        this.installAppleMenu(menubar);
    }

    @Override
    public void installOptionalMenus(MenuBar menubar) {
        this.installFileMenu(menubar);
        this.installEditMenu(menubar);
        this.installWindowMenu(menubar);
    }

    @Override
    public Window createWindow(Window owner, Screen screen, int styleMask) {
        return new MacWindow(owner, screen, styleMask);
    }

    @Override
    public Window createWindow(long parent) {
        throw new RuntimeException("child windows aren't supported on Mac");
    }

    @Override
    public View createView(Pen pen) {
        return new MacView(pen);
    }

    @Override
    public Cursor createCursor(int type) {
        return new MacCursor(type);
    }

    @Override
    public Cursor createCursor(int x, int y, Pixels pixels) {
        return new MacCursor(x, y, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean visible) {
        MacCursor.setVisible_impl(visible);
    }

    @Override
    protected Size staticCursor_getBestSize(int width, int height) {
        return MacCursor.getBestSize_impl(width, height);
    }

    @Override
    public Pixels createPixels(int width, int height, ByteBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    public Pixels createPixels(int width, int height, IntBuffer data) {
        return new MacPixels(width, height, data);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return MacPixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        return new MacRobot();
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return MacScreen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return MacScreen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int x, int y) {
        return MacScreen.getScreenForLocation_impl(x, y);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long screenPtr) {
        return MacScreen.getScreenForPtr_impl(screenPtr);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return MacScreen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new MacTimer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return MacTimer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return MacTimer.getMaxPeriod_impl();
    }

    @Override
    protected String[] staticCommonDialogs_showFileChooser(Window owner, String folder, String title, int type, boolean multipleMode, CommonDialogs.ExtensionFilter[] extensionFilters) {
        return MacCommonDialogs.showFileChooser_impl(owner, folder, title, type, multipleMode, extensionFilters);
    }

    @Override
    protected String staticCommonDialogs_showFolderChooser() {
        return MacCommonDialogs.showFolderChooser_impl();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return MacView.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return MacView.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return MacView.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    protected native void _invokeLater(Runnable var1);

    @Override
    protected native void _postOnEventQueue(Runnable var1);

    static {
        Application.loadNativeLibrary();
        MacApplication._initIDs();
    }
}

