/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.uitoolkit.impl.fx;

import com.sun.applet2.Applet2Context;
import com.sun.applet2.Applet2Host;
import com.sun.deploy.trace.Trace;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import netscape.javascript.JSObject;
import sun.plugin2.applet2.Plugin2Host;

public class DeployPerfLogger {
    private static Applet2Context ctx;
    private static boolean gotError;
    private static final List<Record> queue;
    public static boolean PERF_LOG_ENABLED;
    private static JSObject js;
    private static PerfLoggerThread logger;
    public static long lastReported;
    private static long firstReported;

    private static synchronized JSObject getJSObject() {
        Applet2Host host;
        if (js != null) {
            return js;
        }
        if (ctx != null && (host = ctx.getHost()) instanceof Plugin2Host) {
            try {
                js = ((Plugin2Host)host).getJSObject();
            }
            catch (Exception e) {
                ctx = null;
            }
        }
        return js;
    }

    public static void setContext(Applet2Context c) {
        if (!PERF_LOG_ENABLED) {
            return;
        }
        ctx = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void flushQueue() {
        boolean repeat = true;
        JSObject js = DeployPerfLogger.getJSObject();
        if (js == null) {
            return;
        }
        while (repeat) {
            Record r;
            List<Record> list = queue;
            synchronized (list) {
                r = !queue.isEmpty() ? queue.remove(0) : null;
            }
            if (r != null) {
                DeployPerfLogger.report(js, r);
                continue;
            }
            repeat = false;
        }
    }

    private static void report(JSObject js, Record r) {
        long now = System.nanoTime();
        long offset = (r.tm - now) / 1000000L;
        String label = r.label;
        if (lastReported == 0L) {
            firstReported = now;
        }
        if (lastReported != 0L) {
            label = "[" + (now - firstReported + 500000L) / 1000000L + " ms" + "(delta=" + (now - lastReported + 500000L) / 1000000L + ")] " + label;
        }
        Trace.println((String)("PERFLOG: report [" + label + "]"));
        js.eval("if (typeof perfLog == 'function') {    perfLog(" + offset + ", '" + label + "');}");
        lastReported = now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timestamp(String label) {
        long tm = System.nanoTime();
        if (PERF_LOG_ENABLED && logger != null && logger.isActive()) {
            List<Record> list = queue;
            synchronized (list) {
                queue.add(new Record(tm, label));
                queue.notifyAll();
            }
        }
    }

    static {
        gotError = false;
        queue = new LinkedList<Record>();
        PERF_LOG_ENABLED = false;
        js = null;
        logger = null;
        PERF_LOG_ENABLED = false;
        try {
            PERF_LOG_ENABLED = AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() {
                    return "true".equals(System.getProperty("jnlp.fx.perf"));
                }
            });
            if (PERF_LOG_ENABLED) {
                logger = new PerfLoggerThread();
            }
        }
        catch (PrivilegedActionException pae) {
            Trace.ignored((Throwable)pae);
        }
        lastReported = 0L;
        firstReported = 0L;
    }

    static class PerfLoggerThread
    extends Thread {
        private boolean isActive = true;

        synchronized boolean isActive() {
            return this.isActive;
        }

        public PerfLoggerThread() {
            super("Deploy Perf Logger");
            this.setDaemon(true);
            if (PERF_LOG_ENABLED) {
                Trace.println((String)"Starting perf tracing thread");
                this.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                boolean doRun22 = true;
                long tm = System.currentTimeMillis();
                while (doRun22) {
                    if (DeployPerfLogger.getJSObject() != null) {
                        try {
                            DeployPerfLogger.flushQueue();
                            gotError = false;
                        }
                        catch (Exception e) {
                            if (gotError) {
                                doRun22 = false;
                                Trace.ignoredException((Exception)e);
                            } else {
                                gotError = true;
                            }
                            Class<DeployPerfLogger> clazz = DeployPerfLogger.class;
                            // MONITORENTER : com.sun.deploy.uitoolkit.impl.fx.DeployPerfLogger.class
                            js = null;
                            // MONITOREXIT : clazz
                        }
                    } else if (System.currentTimeMillis() - tm > 5000L) {
                        Trace.println((String)"Stop perf tracing as could not get JS object");
                        doRun22 = false;
                    }
                    List list = queue;
                    // MONITORENTER : list
                    try {
                        queue.wait(10000L);
                    }
                    catch (InterruptedException ie) {
                        doRun22 = false;
                    }
                }
                PerfLoggerThread doRun22 = this;
            }
            catch (Throwable t) {
                try {
                    Trace.ignored((Throwable)t);
                    PerfLoggerThread perfLoggerThread = this;
                }
                catch (Throwable throwable) {
                    PerfLoggerThread perfLoggerThread = this;
                    // MONITORENTER : perfLoggerThread
                    this.isActive = false;
                    // MONITOREXIT : perfLoggerThread
                    throw throwable;
                }
                this.isActive = false;
                // MONITOREXIT : perfLoggerThread
                return;
            }
            // MONITORENTER : doRun22
            this.isActive = false;
            // MONITOREXIT : doRun22
            return;
        }
    }

    static class Record {
        long tm;
        String label;

        public Record(long t, String l) {
            this.tm = t;
            this.label = l;
        }
    }
}

